/*
 * Decompiled with CFR 0.152.
 */
package com.kamikaze.pfordelta;

public class Simple16 {
    private static final int S16_NUMSIZE = 16;
    private static final int S16_BITSSIZE = 28;
    private static final int[] S16_NUM = new int[]{28, 21, 21, 21, 14, 9, 8, 7, 6, 6, 5, 5, 4, 3, 2, 1};
    private static final int[][] S16_BITS = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {4, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {3, 4, 4, 4, 4, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {5, 5, 5, 5, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {4, 4, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 6, 6, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {5, 5, 6, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {10, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {14, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

    public static final int s16Compress(int[] out, int outOffset, int[] in, int inOffset, int n, int blockSize) {
        int numIdx = 0;
        int j = 0;
        int num = 0;
        int bits = 0;
        try {
            for (numIdx = 0; numIdx < 16; ++numIdx) {
                out[outOffset] = numIdx << 28;
                num = S16_NUM[numIdx] < n ? S16_NUM[numIdx] : n;
                bits = 0;
                for (j = 0; j < num && in[inOffset + j] < 1 << S16_BITS[numIdx][j]; ++j) {
                    int n2 = outOffset;
                    out[n2] = out[n2] | in[inOffset + j] << bits;
                    bits += S16_BITS[numIdx][j];
                }
                if (j != num) continue;
                return num;
            }
        }
        catch (Exception e) {
            System.out.println("s16Compress: numIdx:" + numIdx + ",j:" + j + ",num:" + num + ",bits: " + bits);
            e.printStackTrace();
        }
        return -1;
    }

    public static final int s16Decompress(int[] out, int outOffset, int[] in, int inOffset, int n) {
        int j = 0;
        int bits = 0;
        int numIdx = in[inOffset] >>> 28;
        int num = S16_NUM[numIdx] < n ? S16_NUM[numIdx] : n;
        bits = 0;
        for (j = 0; j < num; ++j) {
            out[outOffset + j] = Simple16.readBitsForS16(in, inOffset, bits, S16_BITS[numIdx][j]);
            bits += S16_BITS[numIdx][j];
        }
        return num;
    }

    private static int readBitsForS16(int[] in, int inIntOffset, int inWithIntOffset, int bits) {
        int val = in[inIntOffset] >>> inWithIntOffset;
        return val & -1 >>> 32 - bits;
    }
}

