/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.result;

import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.ArrayCacheType;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.util.Console;
import com.portfolioeffect.quant.client.util.DateTimeUtil;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class MethodResult {
    private boolean isDebug = false;
    private boolean hasResult;
    private final boolean hasError;
    private final boolean hasWarning;
    private final String errorMessage;
    private final String warningMessage;
    private String message;
    private HashMap<String, String> infoParams = new HashMap();
    private Map<String, Object> data = new HashMap<String, Object>();
    private Map<String, String> dataType = new HashMap<String, String>();

    public MethodResult() {
        this.hasError = false;
        this.hasWarning = false;
        this.errorMessage = "";
        this.message = "";
        this.warningMessage = "";
        this.hasResult = false;
    }

    public MethodResult(String errorMessage) {
        this.hasError = true;
        this.hasWarning = false;
        this.errorMessage = errorMessage;
        this.message = "";
        this.warningMessage = "";
        this.hasResult = false;
    }

    public MethodResult(String errorMessage, String warnnigMessage) {
        this.hasError = false;
        this.hasWarning = true;
        this.errorMessage = errorMessage;
        this.message = "";
        this.warningMessage = warnnigMessage;
        this.hasResult = false;
    }

    public MethodResult(boolean hasError, String errorMessage) {
        this.hasError = hasError;
        this.errorMessage = errorMessage;
        this.message = "";
        this.hasWarning = false;
        this.warningMessage = "";
        this.hasResult = false;
    }

    public HashMap<String, String> getInfoParams() {
        return this.infoParams;
    }

    public void setInfoParams(HashMap<String, String> infoParams) {
        this.infoParams = infoParams;
        this.hasResult = true;
    }

    public void setInfo(HashMap<String, String> info) {
        this.infoParams.putAll(info);
        this.hasResult = true;
    }

    public String getDataType(String key) {
        return this.dataType.get(key);
    }

    public void setData(String key, ArrayCache value) {
        this.data.put(key, value);
        this.dataType.put(key, value.getType().toString());
        this.hasResult = true;
    }

    public ArrayCache getDataArrayCache(String key) {
        return (ArrayCache)this.data.get(key);
    }

    public void setData(String key, ArrayCache[] value) {
        this.data.put(key, value);
        this.dataType.put(key, value[0].getType().toString());
        this.hasResult = true;
    }

    public ArrayCache[] getDataArrayCacheArray(String key) {
        return (ArrayCache[])this.data.get(key);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public String getDataString(String key) {
        return (String)this.data.get(key);
    }

    public String[] getDataNames() {
        return this.data.keySet().toArray(new String[this.data.keySet().size()]);
    }

    public Portfolio getPortfolio(String key) {
        return (Portfolio)this.data.get(key);
    }

    public void setPortfolio(String key, Portfolio portfolio) {
        this.dataType.put(key, "PORTFOLIO");
        this.data.put(key, portfolio);
        this.hasResult = true;
    }

    public long[] getLongArray(String key) {
        try {
            if (this.data.containsKey("value")) {
                long[] data = ((ArrayCache)this.data.get(key)).getLongArray(this.getDataArrayCache("value"));
                if (this.isDebug && key.equals("time") && data.length > 0) {
                    Console.writeln("RESULT TIME(" + data.length + "): " + new Timestamp(data[0] + DateTimeUtil.CLIENT_TIME_DELTA) + "\t" + new Timestamp(data[data.length - 1] + DateTimeUtil.CLIENT_TIME_DELTA));
                }
                return data;
            }
            long[] data = ((ArrayCache)this.data.get(key)).getLongArray();
            if (this.isDebug && key.equals("time") && data.length > 0) {
                Console.writeln("RESULT TIME(" + data.length + "): " + new Timestamp(data[0] + DateTimeUtil.CLIENT_TIME_DELTA) + "\t" + new Timestamp(data[data.length - 1] + DateTimeUtil.CLIENT_TIME_DELTA));
            }
            return data;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public long getLastLong(String key) {
        long[] x = new long[]{-1L};
        try {
            x = ((ArrayCache)this.data.get(key)).getLongArray(this.getDataArrayCache("value"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return x[x.length - 1];
    }

    public double getLastDouble(String key) {
        double[] x = new double[]{0.0};
        try {
            x = ((ArrayCache)this.data.get(key)).getDoubleArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return x[x.length - 1];
    }

    public double[] getLastDoubleArray(String key) {
        Object x = new double[][]{{0.0}};
        try {
            x = ((ArrayCache)this.data.get(key)).getDoubleMatrix();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return x[((double[][])x).length - 1];
    }

    public double[] getDoubleArray(String key) {
        try {
            double[] data = ((ArrayCache)this.data.get(key)).getDoubleArray();
            if (this.isDebug && data.length > 0) {
                Console.writeln("RESULT DATA(" + data.length + "): " + data[0] + "\t" + data[data.length - 1]);
            }
            return data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double[][] getDoubleMatrix(String key) {
        try {
            return ((ArrayCache)this.data.get(key)).getDoubleMatrix();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getInfoParam(String key) {
        if (!this.infoParams.containsKey(key)) {
            return String.format("No such parameters: %s", key);
        }
        return this.infoParams.get(key);
    }

    public String getParamName() {
        String params = "";
        for (String e : this.infoParams.keySet()) {
            params = params + " " + e;
        }
        return params;
    }

    public int getValueInt(String key) {
        if (!this.infoParams.containsKey(key)) {
            return 0;
        }
        return Integer.parseInt(this.infoParams.get(key));
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void makeLastResultOnlyDouble(String key) {
        try {
            ArrayCache newResult = new ArrayCache(ArrayCacheType.NULL);
            double[] resultArray = null;
            try {
                resultArray = this.getDoubleArray(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (resultArray.length == 0) {
                return;
            }
            newResult = new ArrayCache(new double[]{resultArray[resultArray.length - 1]});
            this.setData(key, newResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeLastResultOnlyLong(String key) {
        try {
            ArrayCache newTime = new ArrayCache(ArrayCacheType.NULL);
            long[] timeArray = null;
            try {
                timeArray = this.getLongArray(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            newTime = new ArrayCache(new long[]{timeArray[timeArray.length - 1]});
            this.setData(key, newTime);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeLastResultOnlyDouble(String key, int batchSize) {
        try {
            ArrayCache newResult = new ArrayCache(ArrayCacheType.NULL);
            double[] resultArray = null;
            try {
                resultArray = this.getDoubleArray(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            double[] valuesLast = new double[batchSize];
            if (resultArray.length == 0) {
                return;
            }
            for (int i = 0; i < batchSize; ++i) {
                valuesLast[i] = resultArray[resultArray.length - batchSize + i];
            }
            newResult = new ArrayCache(valuesLast);
            this.setData(key, newResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeLastResultOnlyLong(String key, int batchSize) {
        try {
            ArrayCache newTime = new ArrayCache(ArrayCacheType.NULL);
            long[] timeArray = null;
            timeArray = this.getLongArray(key);
            newTime = new ArrayCache(new long[]{timeArray[timeArray.length - 1]});
            this.setData(key, newTime);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getStringArray(String key) {
        try {
            return ((ArrayCache)this.data.get(key)).getStringArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isHasResult() {
        return this.hasResult;
    }

    public boolean isNaNFiltered() {
        if (this.data.containsKey("value")) {
            return this.getDataArrayCache("value").isNaNFiltered();
        }
        return true;
    }

    public void setNaNFiltered(boolean isNaNFiltered) throws Exception {
        if (!this.data.containsKey("value")) {
            throw new Exception("Error in MethodResult -1");
        }
        this.getDataArrayCache("value").setNaNFiltered(isNaNFiltered);
    }

    public boolean isNaN2Zero() {
        if (this.data.containsKey("value")) {
            return this.getDataArrayCache("value").isNaN2Zero();
        }
        return true;
    }

    public void setNaN2Zero(boolean isNaN2Zero) throws Exception {
        if (!this.data.containsKey("value")) {
            throw new Exception("Error in MethodResult -1");
        }
        this.getDataArrayCache("value").setNaN2Zero(isNaN2Zero);
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }
}

