% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{apply_regime}
\alias{apply_regime}
\title{Apply Market Regime Filter}
\usage{
apply_regime(selection_df, regime_condition, partial_weight = 0)
}
\arguments{
\item{selection_df}{Binary selection matrix}

\item{regime_condition}{Logical vector (TRUE = trade, FALSE = cash)}

\item{partial_weight}{Fraction to hold when regime is FALSE (default: 0)}
}
\value{
Modified selection matrix respecting regime
}
\description{
Applies regime-based filtering. When regime is FALSE (e.g., bear market),
all selections become 0, moving portfolio to cash.
}
\examples{
data("sample_prices_weekly")
# Create selection
momentum <- calc_momentum(sample_prices_weekly, 12)
selected <- filter_top_n(momentum, 10)

# Only trade when SPY above 20-week MA
ma20 <- calc_moving_average(sample_prices_weekly, 20)
spy_regime <- sample_prices_weekly$SPY > ma20$SPY
spy_regime[is.na(spy_regime)] <- FALSE

regime_filtered <- apply_regime(selected, spy_regime)
}
