% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_powerest.R
\name{vis_powerest}
\alias{vis_powerest}
\title{Visualization of the power surface}
\usage{
vis_powerest(x,color="heat",contour.col=NULL,
se=-1,zlim=NULL,n.grid=30,col=NA,plot.type="persp",
nCol=50,...)
}
\arguments{
\item{x}{A \href{https://CRAN.R-project.org/package=scam}{scam} object.}

\item{color}{The color of the plot which can be one of the "heat", "topo", "cm", "terrain", "gray" or "bw".}

\item{contour.col}{The color of the contour plot when using plot.type="contour".}

\item{se}{If less than or equal to zero then only the predicted surface is plotted, but if
greater than zero, then 3 surfaces are plotted, one at the predicted values minus se standard errors,
one at the predicted values and one at the predicted values plus se standard errors.}

\item{zlim}{The range of power value the user want to show.}

\item{n.grid}{The number of grid nodes in each direction used for calculating the plotted surface.}

\item{col}{The colors for the facets of the plot. If this is NA then if se>0 the facets are transparent,
otherwise the color scheme specified in color is used. If col is not NA then it is used as the facet color.}

\item{plot.type}{One of "contour" or "persp".}

\item{nCol}{The number of colors to use in color schemes.}

\item{...}{Other arguments.}
}
\value{
A 2d plot of the power surface. More details can be seen at \href{https://CRAN.R-project.org/package=scam}{scam}.
}
\description{
This function takes the result from 'pred_powerest' and plots 2D views of it,
supply ticktype="detailed" to get proper axis annotation and is a modified version of the 'scam' library code 'vis.scam'.
}
\examples{
data(result_example)
 \donttest{b<-fit_powerest(result_example$power,result_example$avg_logFC,result_example$avg_PCT)}
 \donttest{pred <- pred_powerest(b,xlim= c(0,6),ylim=c(0,1))}
 \donttest{vis_powerest(pred,theta=-30,phi=30,color='heat',ticktype = "detailed",xlim=c(0,6),nticks=5)}

}
\author{
Lan Shui \email{lshui@mdanderson.org} based partly on 'scam' by Natalya Pya
}
