% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrInDTMulab.R
\name{PrInDTMulab}
\alias{PrInDTMulab}
\title{Multiple label classification based on resampling by \code{\link{PrInDT}}}
\usage{
PrInDTMulab(datain,classnames=NA,ctestv=NA,conf.level=0.95,percl,percs=1,N,
               indind=NA,indaddind=NA,inddep,minsplit=NA,minbucket=NA)
}
\arguments{
\item{datain}{Input data frame with class factor variable 'classname' and the\cr
influential variables, which need to be factors or numericals (transform logicals and character variables to factors)}

\item{classnames}{names of class variables (character vector); default = NA: from old version: superfluous now}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
(see function \code{\link{PrInDT}} for details.)\cr
If no restrictions exist, the default = NA is used.}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical, > 0 and <= 1);\cr
default = 0.95}

\item{percl}{list of undersampling percentages of larger class (numerical, > 0 and <= 1): one per dependent class variable}

\item{percs}{list of undersampling percentage of smaller class (numerical, > 0 and <= 1); one per dependent class variable}

\item{N}{no. of repetitions (integer > 0)}

\item{indind}{indices of independent variables}

\item{indaddind}{indices of additional independent variables used in the case of dependent binary relevance modeling}

\item{inddep}{indices of dependent variables}

\item{minsplit}{Minimum number of elements in a node to be splitted;\cr
default = 20}

\item{minbucket}{Minimum number of elements in a node;\cr
default = 7}
}
\value{
\describe{
\item{accbr}{model errors for Binary Relevance (single assessment) - only independent predictors are used for modeling one label at a time,
the other labels are not used as predictors. As the performance measure for the resulting classification rules,
the balanced accuracy of the best model from PrInDT is employed for each individual label.}
\item{errbin}{combined error for Binary Relevance (joint assessment) - the best prediction models for the different labels are combined  
to assess the combined prediction. The 01-accuracy counts a label combination as correct only if all labels are correctly predicted.
The hamming accuracy corresponds to the proportion of labels whose value is correctly predicted.}
\item{accdbr}{model errors for Dependent Binary Relevance (Extended Model) (single assessment) - each label is trained by means of an extended model which 
not only includes the independent predictors but also the other labels. For these labels, the truly observed values are used for 
estimation and prediction. In the extended model, other labels, which are not treated as dependent variables, can also be used as additional predictors.}
\item{errext}{combined errors for Dependent Binary Relevance (Extended Model) (joint assessment)}
\item{errtrue}{combined errors for Dependent Binary Relevance (True Prediction) - in the prediction phase, the values 
of all modeled labels are first predicted by the independent predictors only and then the predicted labels are used in the estimated  
extended model in a 2nd step to 
ultimately predict the labels.}
\item{coldata}{column names of input data}
\item{inddep}{indices of dependent variables (labels to be modeled)}
\item{treebr}{list of trees from Binary Relevance modeling, one tree for each label; refer to an individual tree as \code{treebr[[i]]}, 
                i = 1, ..., no. of labels}
\item{treedbr}{list of trees from Dependent Binary Relevance modeling, one for each label; refer to an individual tree as \code{treedbr[[i]]}, 
                i = 1, ..., no. of labels}
}
}
\description{
Multiple label classification based on resampling by \code{\link{PrInDT}}. We consider two ways of modeling (Binary relevance modeling, 
dependent binary modeling) and three ways of model evaluation: single assessment, joint assessment, and true prediction  
(see the Value section for more information).\cr
Variables should be arranged in 'datain' according to indices specified in 'indind', 'indaddind', and 'inddep'.\cr
Please note that the dependent variables have to be specified as dummies, i.e. as 'absent' (value 0) or 'present' (value 1).\cr
Undersampling is repeated 'N' times.\cr
Undersampling percentages 'percl' for the larger class and 'percs' for the smaller class can be 
specified, one each per dependent class variable.\cr
The parameters 'conf.level', 'minsplit', and 'minbucket' can be used to control the size of the trees.\cr

\strong{References}\cr 
- Buschfeld, S., Weihs, C. and Ronan, P.. 2024. Modeling linguistic landscapes: A comparison of St Martin’s two capitals Philipsburg and Marigot Linguistic Landscape 10(3): 302–334. https://doi.org/10.1075/ll.23070.bus\cr
- Probst, P., Au, Q., Casalicchio, G., Stachl, C., and Bischl, B. 2017. Multilabel Classification with R Package mlr. arXiv:1703.08991v2
}
\details{
Standard output can be produced by means of \code{print(name)} or just \code{ name } as well as \code{plot(name)}  where 'name' is the output data 
frame of the function.\cr
The plot function will produce a series of more than one plot. If you use R, you might want to specify \code{windows(record=TRUE)} before 
\code{plot(name)} to save the whole series of plots. In R-Studio this functionality is provided automatically.
}
\examples{
data <- PrInDT::data_land # load data
dataclean <- data[,c(1:7,23:24,11:13,22,8:10)]  # only relevant features
indind <- c(1:9) # original predictors
indaddind <- c(10:13) # additional predictors
inddep <- c(14:16) # dependent variables
dataclean <- na.omit(dataclean)
ctestv <- NA
N <- 21  # no. of repetitions
perc <- c(0.45,0.05,0.25)   # percentages of observations of larger class, 
#                             1 per dependent class variable
perc2 <- c(0.75,0.95,0.75)  # percentages of observations of smaller class, 
#                             1 per dependent class variable
##
# Call PrInDT: language by language
##
outmult <- PrInDTMulab(dataclean,ctestv=NA,conf.level=0.95,percl=perc,percs=perc2,N=N,
                  indind=indind,indaddind=indaddind,inddep=inddep)
print(outmult)
plot(outmult)

}
