% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{autocor.plot}
\alias{autocor.plot}
\title{Plot of the autocorrelgram for posterior samples}
\usage{
autocor.plot(object, param, component.beta = NULL, component.S = NULL)
}
\arguments{
\item{object}{an object of class 'Bayes.PrevMap'.}

\item{param}{a character indicating for which component of the model the autocorrelation plot is required: \code{param="beta"} for the regression coefficients; \code{param="sigma2"} for the variance of the spatial random effect; \code{param="phi"} for the scale parameter of the Matern correlation function; \code{param="tau2"} for the variance of the nugget effect; \code{param="S"} for the spatial random effect.}

\item{component.beta}{if \code{param="beta"}, \code{component.beta} is a numeric value indicating the component of the regression coefficients; default is \code{NULL}.}

\item{component.S}{if \code{param="S"}, \code{component.S} can be a numeric value indicating the component of the spatial random effect, or set equal to \code{"all"} if the autocorrelgram should be plotted for all the components. Default is \code{NULL}.}
}
\description{
Plots the autocorrelogram for the posterior samples of the model parameters and spatial random effects.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}

