% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{glgm.LA}
\alias{glgm.LA}
\title{Maximum Likelihood estimation for generalised linear geostatistical models via the Laplace approximation}
\usage{
glgm.LA(formula, units.m = NULL, coords, times = NULL, data,
  ID.coords = NULL, kappa, kappa.t = 0.5, fixed.rel.nugget = NULL,
  start.cov.pars, method = "nlminb", messages = TRUE, family,
  return.covariance = TRUE)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{units.m}{an object of class \code{\link{formula}} indicating the binomial denominators in the data.}

\item{coords}{an object of class \code{\link{formula}} indicating the spatial coordinates in the data.}

\item{times}{an object of class \code{\link{formula}} indicating the times in the data, used in the spatio-temporal model.}

\item{data}{a data frame containing the variables in the model.}

\item{ID.coords}{vector of ID values for the unique set of spatial coordinates obtained from \code{\link{create.ID.coords}}. These must be provided if, for example, spatial random effects are defined at household level but some of the covariates are at individual level. \bold{Warning}: the household coordinates must all be distinct otherwise see \code{\link{jitterDupCoords}}. Default is \code{NULL}.}

\item{kappa}{fixed value for the shape parameter of the Matern covariance function.}

\item{kappa.t}{fixed value for the shape parameter of the Matern covariance function in the separable double-Matern spatio-temporal model.}

\item{fixed.rel.nugget}{fixed value for the relative variance of the nugget effect; \code{fixed.rel.nugget=NULL} if this should be included in the estimation. Default is \code{fixed.rel.nugget=NULL}.}

\item{start.cov.pars}{a vector of length two with elements corresponding to the starting values of \code{phi} and the relative variance of the nugget effect \code{nu2}, respectively, that are used in the optimization algorithm. If \code{nu2} is fixed through \code{fixed.rel.nugget}, then \code{start.cov.pars} represents the starting value for \code{phi} only.}

\item{method}{method of optimization. If \code{method="BFGS"} then the \code{\link{maxBFGS}} function is used; otherwise \code{method="nlminb"} to use the \code{\link{nlminb}} function. Default is \code{method="BFGS"}.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}

\item{family}{character, indicating the conditional distribution of the outcome. This should be \code{"Gaussian"}, \code{"Binomial"} or \code{"Poisson"}.}

\item{return.covariance}{logical; if \code{return.covariance=TRUE} then a numerical estimation of the covariance function for the model parameters is returned. Default is \code{return.covariance=TRUE}.}
}
\value{
An object of class "PrevMap".
The function \code{\link{summary.PrevMap}} is used to print a summary of the fitted model.
The object is a list with the following components:

\code{estimate}: estimates of the model parameters; use the function \code{\link{coef.PrevMap}} to obtain estimates of covariance parameters on the original scale.

\code{covariance}: covariance matrix of the MCML estimates.

\code{log.lik}: maximum value of the log-likelihood.

\code{y}: binomial observations.

\code{units.m}: binomial denominators.

\code{D}: matrix of covariates.

\code{coords}: matrix of the observed sampling locations.

\code{times}: vector of the time points used in a spatio-temporal model.

\code{method}: method of optimization used.

\code{ID.coords}: set of ID values defined through the argument \code{ID.coords}.

\code{kappa}: fixed value of the shape parameter of the Matern function.

\code{kappa.t}: fixed value for the shape parameter of the Matern covariance function in the separable double-Matern spatio-temporal model.

\code{fixed.rel.nugget}: fixed value for the relative variance of the nugget effect.

\code{call}: the matched call.
}
\description{
This function performs the Laplace method for maximum likelihood estimation of a generalised linear geostatistical model.
}
\details{
This function performs parameter estimation for a generealized linear geostatistical model. Conditionally on a zero-mean stationary Gaussian process \eqn{S(x)} and mutually independent zero-mean Gaussian variables \eqn{Z} with variance \code{tau2}, the observations \code{y} are generated from a GLM
with link function \eqn{g(.)} and linear predictor
\deqn{\eta = d'\beta + S(x) + Z,}
where \eqn{d} is a vector of covariates with associated regression coefficients \eqn{\beta}. The Gaussian process \eqn{S(x)} has isotropic Matern covariance function (see \code{\link{matern}}) with variance \code{sigma2}, scale parameter \code{phi} and shape parameter \code{kappa}.
The shape parameter is treated as fixed. The relative variance of the nugget effect, \code{nu2=tau2/sigma2}, can also be fixed through the argument \code{fixed.rel.nugget}; if \code{fixed.rel.nugget=NULL}, then the relative variance of the nugget effect is also included in the estimation.

\bold{Laplace Approximation}
The Laplace approximation (LA) method uses a second-order Taylor expansion of the integrand expressing the likelihood function. The resulting approximation of the likelihood is then maximized by a numerical optimization as defined through the argument \code{method}.

\bold{Using a two-level model to include household-level and individual-level information.}
When analysing data from household sruveys, some of the avilable information information might be at household-level (e.g. material of house, temperature) and some at individual-level (e.g. age, gender). In this case, the Gaussian spatial process \eqn{S(x)} and the nugget effect \eqn{Z} are defined at hosuehold-level in order to account for extra-binomial variation between and within households, respectively.
}
\references{
Diggle, P.J., Giorgi, E. (2019). \emph{Model-based Geostatistics for Global Public Health.} CRC/Chapman & Hall.

Giorgi, E., Diggle, P.J. (2017). \emph{PrevMap: an R package for prevalence mapping.} Journal of Statistical Software. 78(8), 1-29. doi: 10.18637/jss.v078.i08

Christensen, O. F. (2004). \emph{Monte carlo maximum likelihood in model-based geostatistics.} Journal of Computational and Graphical Statistics 13, 702-718.

Higdon, D. (1998). \emph{A process-convolution approach to modeling temperatures in the North Atlantic Ocean.} Environmental and Ecological Statistics 5, 173-190.
}
\seealso{
\code{\link{Laplace.sampling}}, \code{\link{Laplace.sampling.lr}}, \code{\link{summary.PrevMap}}, \code{\link{coef.PrevMap}}, \code{\link{matern}}, \code{\link{matern.kernel}},  \code{\link{control.mcmc.MCML}}, \code{\link{create.ID.coords}}.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
