% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{sampleRate}
\alias{noteToSampleRate}
\alias{periodToSampleRate}
\alias{sampleRate}
\title{Calculate the sample rate for a note or period value}
\usage{
noteToSampleRate(note = "C-3", finetune = 0, video = c("PAL", "NTSC"))

periodToSampleRate(period, video = c("PAL", "NTSC"))
}
\arguments{
\item{note}{A \code{character} string representing a note for which the sample
rate is to be calculated.}

\item{finetune}{An \code{integer} value ranging from -8 up to 7. A value used to
tune an audio sample.}

\item{video}{The video mode used to calculate the sample rate. A \code{character}
string that can have either the value `\href{https://en.wikipedia.org/wiki/PAL}{PAL}'
or `\href{https://en.wikipedia.org/wiki/NTSC}{NTSC}'. PAL is used by default.}

\item{period}{A ProTracker \code{integer} value of a period value for which the sample rate
is to be calculated.}
}
\value{
Returns the sample rate in samples per seconds.
}
\description{
Calculate the sample rate for a note or a ProTracker period value.
}
\details{
The timing on a Commodore Amiga depends on the video mode, which could be
either `\href{https://en.wikipedia.org/wiki/PAL}{PAL}'
or `\href{https://en.wikipedia.org/wiki/NTSC}{NTSC}'. Therefore sample
rates also depend on these modes. As the PAL is mostly used in Europe, and
the Amiga was most popular in Europe, PAL is used by default.
}
\examples{
## calculate the sample rate for a ProTracker period value of 200
periodToSampleRate(200)

## calculate the sample rate for a sample at note 'A-3'
noteToSampleRate("A-3")

## note that the NTSC video system gives a slightly different rate:
noteToSampleRate("A-3", video = "NTSC")

## fine tuning a sample will also give a slightly different rate:
noteToSampleRate("A-3", finetune = -1)
}
\author{
Pepijn de Vries
}
\seealso{
Other character.operations: \code{\link{as.character}},
  \code{\link{as.character,PTCell-method}},
  \code{\link{as.character,PTPattern-method}},
  \code{\link{as.character,PTTrack-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{periodToChar}}; \code{\link{rawToCharNull}}

Other note.and.octave.operations: \code{\link{noteDown}},
  \code{\link{noteDown,PTCell-method}},
  \code{\link{noteDown,PTPattern-method}},
  \code{\link{noteDown,PTTrack-method}},
  \code{\link{noteUp}}, \code{\link{noteUp,PTCell-method}},
  \code{\link{noteUp,PTPattern-method}},
  \code{\link{noteUp,PTTrack-method}},
  \code{\link{octaveDown}},
  \code{\link{octaveDown,PTCell-method}},
  \code{\link{octaveDown,PTPattern-method}},
  \code{\link{octaveDown,PTTrack-method}},
  \code{\link{octaveUp}},
  \code{\link{octaveUp,PTCell-method}},
  \code{\link{octaveUp,PTPattern-method}},
  \code{\link{octaveUp,PTTrack-method}};
  \code{\link{noteToPeriod}}; \code{\link{note}},
  \code{\link{note,PTCell-method}},
  \code{\link{note,numeric-method}}, \code{\link{note<-}},
  \code{\link{note<-,PTCell,character-method}};
  \code{\link{octave}}, \code{\link{octave,PTCell-method}},
  \code{\link{octave,numeric-method}},
  \code{\link{octave<-}},
  \code{\link{octave<-,PTCell,numeric-method}};
  \code{\link{periodToChar}}

Other period.operations: \code{\link{noteToPeriod}};
  \code{\link{note}}, \code{\link{note,PTCell-method}},
  \code{\link{note,numeric-method}}, \code{\link{note<-}},
  \code{\link{note<-,PTCell,character-method}};
  \code{\link{octave}}, \code{\link{octave,PTCell-method}},
  \code{\link{octave,numeric-method}},
  \code{\link{octave<-}},
  \code{\link{octave<-,PTCell,numeric-method}};
  \code{\link{periodToChar}}; \code{\link{period_table}}

Other sample.rate.operations: \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}}
}

