% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10ModArchiveHelpers.r
\name{modArchive}
\alias{modArchive}
\alias{modArchive.download}
\alias{modArchive.info}
\alias{modArchive.search.mod}
\title{ModArchive helper functions}
\usage{
modArchive.info(mod.id)

modArchive.download(mod.id)

modArchive.search.mod(search.text, search.where = c("filename_or_songtitle",
  "filename_and_songtitle", "filename", "songtitle", "module_instruments",
  "module_comments"), format.filter = c("unset", "669", "AHX", "DMF", "HVL",
  "IT", "MED", "MO3", "MOD", "MTM", "OCT", "OKT", "S3M", "STM", "XM"),
  size.filter = c("unset", "0-99", "100-299", "300-599", "600-1025",
  "1025-2999", "3072-6999", "7168-100000"), genre.filter = c("unset",
  "Alternative", "Gothic", "Grunge", "Metal - Extreme", "Metal (general)",
  "Punk", "Chiptune", "Demo Style", "One Hour Compo", "Chillout",
  "Electronic - Ambient", "Electronic - Breakbeat", "Electronic - Dance",
  "Electronic - Drum and Bass", "Electronic - Gabber", "Electronic - Hardcore",
  "Electronic - House", "Electronic - IDM", "Electronic - Industrial",
  "Electronic - Jungle", "Electronic - Minimal", "Electronic - Other",
  "Electronic - Progressive", "Electronic - Rave", "Electronic - Techno",     
  "Electronic (general)", "Trance - Acid", "Trance - Dream", "Trance - Goa",
  "Trance - Hard", "Trance - Progressive", "Trance - Tribal",
  "Trance (general)", "Big Band", "Blues", "Jazz - Acid", "Jazz - Modern",
  "Jazz (general)", "Swing", "Bluegrass", "Classical", "Comedy", "Country",
  "Experimental", "Fantasy", "Folk", "Fusion", "Medieval", "New Ages",
  "Orchestral", "Other", "Piano", "Religious", "Soundtrack", "Spiritual",
  "Video Game", "Vocal Montage", "World", "Ballad", "Disco", "Easy Listening",  
     "Funk", "Pop - Soft", "Pop - Synth", "Pop (general)", "Rock - Hard",
  "Rock - Soft", "Rock (general)", "Christmas", "Halloween", "Hip-Hop",
  "R and B", "Reggae", "Ska", "Soul"))
}
\arguments{
\item{mod.id}{An \code{integer} code used as module identifier in the ModArchive database.
A \code{mod.id} can be obtained by performing a search with \code{modArchive.search.mod}.
When downloading a module, make sure that the identifier represents a MOD file, as
other types will result in an error.}

\item{search.text}{A \code{character} string to be used as terms to search
in the ModArchive.}

\item{search.where}{A \code{character} string indicating where in the module files
to search for the \code{search.text}. See usage section for the available options.}

\item{format.filter}{File format filter to be used in a search in the ModArchive.
See the usage section for all possible options. Default is "unset" (meaning that
it will search for any file format). Note that only the `MOD' format
is supported by this package.}

\item{size.filter}{File size filter to be used in a search in the ModArchive.
Needs to be a \code{character} string representation of a file size
category as specified on ModArchive.org.
See the usage section for all possible options. Default is "unset" (meaning that
it will search for any file size). Note that the maximum file size of a
module is approximately 4068 kilobytes, meaning that the largest file size
category is irrelevant for `MOD' files. Also note that the category names are
inconsistant, these are the literal catagories used by ModArchive}

\item{genre.filter}{Genre filter to be used in a search in the ModArchive.
Needs to be a \code{character} string representation of a genre
as specified on ModArchive.org.
See the usage section for all possible options. Default is "unset" (meaning that
it will search for any genre).}
}
\value{
\code{modArchive.info} will return a \code{\link{list}} with module info.
\code{modArchive.download} will download a module and return it as a
\code{\link{PTModule}} object. \code{modArchive.download} will search on the modArchive
and return the first page of search results in the form of a \code{\link{data.frame}}.
}
\description{
\url{http://ModArchive.org} is the largest online archive of module files. These functions
will assist in accessing this archive.
}
\details{
The \code{modArchive.info} function will retrieve info on a specific module from the
ModArchive. The \code{modArchive.download} will download modules from the archive.
The \code{modArchive.search.mod} function will search the archive for modules. Note
that the ModArchive also contains file formats other that ProTracker's MOD format.
This package will only handle the MOD format.
}
\note{
The `\code{modArchive}' functions were created for your convenience.
However, users and developers should not rely too heavily on them for
the following two reasons:
\itemize{
\item{The ModArchive is developed and maintained by a third party. Changes
in the structure of that database or the dissemination of the data may
cause the functions in this package to fail. I don't have any control on
these kind of changes.}
\item{Some of the \code{modArchive} functions implemented here, rely on regular
expressions to lookup information in ModArchive html code. I do realise
that using regular expressions in html code is the root of all evil (as
html is not a regular language). However, this approach is used to keep this package
light (i.e., not to rely on too many other packages), without having to write
a custom html-parser. That being said, this approach should work in most
cases, but may fail in some.}
}
}
\examples{
\dontrun{
## Search for the module that is also used as
## an example in this package:
search.results <- modArchive.search.mod("ProTrackR", "module_instruments", "MOD")

## apparently there are multiple modules in
## database that use 'ProTrackR' as a
## sample name. Select the actual module from the
## list:
search.select <- subset(search.results, title == "intro")

## get all available details for this mod from
## ModArchive.org:
modArchive.info(search.select$mod.id)

## download the selected module from ModArchive.org:
mod <- modArchive.download(search.select$mod.id)
}
}
\author{
Pepijn de Vries
}

