% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{loopStart}
\alias{loopStart}
\alias{loopStart,PTSample-method}
\alias{loopStart<-}
\alias{loopStart<-,PTSample-method}
\title{The loop start position of a PTSample}
\usage{
\S4method{loopStart}{PTSample}(sample)

\S4method{loopStart}{PTSample}(sample) <- value
}
\arguments{
\item{sample}{A \code{\link{PTSample}} for which the loop start position
needs to be extracted or replace.}

\item{value}{An even \code{numeric} value giving the loop starting position in
samples ranging from 0 up to 131070. The sum of the \code{\link{loopStart}} and
\code{\link{loopLength}} should not exceed the \code{\link{sampleLength}}.

Use a \code{value} of either \code{character} "\code{off}" or \code{logical}
"\code{FALSE}", in order to turn off the loop all together.}
}
\value{
For \code{loopStart} the loop start position (in samples), represented by
an even \code{integer} value ranging from 0 up to 131070, is returned.

For \code{loopStart<-} A \code{\link{PTSample}} \code{sample}, updated
with the loop start position `\code{value}', is returned.
}
\description{
Extract or replace the loop start position of a \code{\link{PTSample}}.
}
\details{
\code{\link{PTSample}}s can have loops, marked by a starting position
and length of the loop (in samples), for more details see the
\code{\link{PTSample-class}}. This method can be used to extract
the loop starting position or safely replace its value.
}
\examples{
data("mod.intro")

## get the loop start position of the
## first sample of mod.intro:

loopStart(PTSample(mod.intro, 1))

## Let's change the starting position of
## the loop to 500

loopStart(PTSample(mod.intro, 1)) <- 500

## Let's turn off the loop all together:

loopStart(PTSample(mod.intro, 1)) <- FALSE

}
\author{
Pepijn de Vries
}
\seealso{
Other loop.methods: \code{\link{loopLength}},
  \code{\link{loopSample}}, \code{\link{loopState}}

Other sample.operations: \code{\link{PTSample-class}},
  \code{\link{PTSample-method}}, \code{\link{fineTune}},
  \code{\link{loopLength}}, \code{\link{loopSample}},
  \code{\link{loopState}}, \code{\link{name}},
  \code{\link{playSample}}, \code{\link{read.sample}},
  \code{\link{sampleLength}}, \code{\link{volume}},
  \code{\link{waveform}}, \code{\link{write.sample}}
}

