% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{periodToChar}
\alias{periodToChar}
\title{Get the note and octave from period table}
\usage{
periodToChar(period)
}
\arguments{
\item{period}{\code{integer} value of a period value.}
}
\value{
\code{periodToChar} returns a \code{character} representing the combination
of octave and note that is closest to
\code{period} in the ProTracker period table.
}
\description{
These functions return the note and octave that is closest to the provided period value.
}
\details{
ProTracker uses a \link{period_table} to link period values to certain
octaves and notes. This function serves to look up corresponding
notes and octaves for specific period values.
}
\examples{
## Note C# in octave 3 is closest to a period of 200 in the table:
periodToChar(200)
## try with a range of period values:
periodToChar(200:400)

}
\seealso{
Other character.operations: \code{\link{as.character}},
  \code{\link{name}}, \code{\link{rawToCharNull}},
  \code{\link{sampleRate}}

Other period.operations: \code{\link{noteToPeriod}},
  \code{\link{note}}, \code{\link{octave}},
  \code{\link{period_table}}, \code{\link{sampleRate}}

Other note.and.octave.operations: \code{\link{noteToPeriod}},
  \code{\link{noteUp}}, \code{\link{note}},
  \code{\link{octave}}, \code{\link{sampleRate}}
}
\author{
Pepijn de Vries
}
