% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\name{clearSong}
\alias{clearSong}
\alias{clearSong,PTModule-method}
\title{Clear all pattern info from module}
\usage{
\S4method{clearSong}{PTModule}(mod)
}
\arguments{
\item{mod}{A \code{\link{PTModule}} object from which all pattern (order)
info needs to be removed.}
}
\value{
Returns a copy of object \code{mod} in which all pattern (order)
info is removed.
}
\description{
Remove all patterns (\code{\link{PTPattern}}) and \code{\link{patternOrder}}
info from a \code{\link{PTModule}} object.
}
\details{
Conform the original ProTracker, this method removes all patterns
(\code{\link{PTPattern}}) and \code{\link{patternOrder}}
info from a module. You keep the audio \code{\link{PTSample}}s.
}
\examples{
data(mod.intro)

## 'clear.mod' is a copy of 'mod.intro' without the
## pattern (order) info. It still has the audio samples.
clear.mod <- clearSong(mod.intro)
}
\seealso{
Other module.operations: 
\code{\link{PTModule-class}},
\code{\link{appendPattern}()},
\code{\link{clearSamples}()},
\code{\link{deletePattern}()},
\code{\link{fix.PTModule}()},
\code{\link{modToWave}()},
\code{\link{moduleSize}()},
\code{\link{patternLength}()},
\code{\link{patternOrderLength}()},
\code{\link{patternOrder}()},
\code{\link{playMod}()},
\code{\link{playingtable}()},
\code{\link{rawToPTModule}()},
\code{\link{read.module}()},
\code{\link{trackerFlag}()},
\code{\link{write.module}()}
}
\author{
Pepijn de Vries
}
\concept{module.operations}
