% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{pt2_read_sample}
\alias{pt2_read_sample}
\alias{pt2_write_sample}
\title{Read and write ProTracker audio samples}
\usage{
pt2_read_sample(file, ...)

pt2_write_sample(sample, file, ...)
}
\arguments{
\item{file}{Filename of the file to read from or write to. For \code{pt2_write_sample()}
the file extension will be used to determine which file format to write.}

\item{...}{Ignored}

\item{sample}{An object of class \code{pt2samp}.}
}
\value{
\code{pt2_read_sample()} returns a \code{pt2samp} class object when successful.
\code{pt_write_sample()} returns \code{NULL} invisibly.
}
\description{
Functions to read and write ProTracker audio samples. Reading is supported
for common types of WAV, IFF and AIFF files. Writing is supported for
WAV and IFF files.
}
\examples{
mod <- pt2_read_mod(system.file("mod.intro", package = "ProTrackR2"))
my_sample <- pt2_sample(mod, 1L)
my_sample_file <- tempfile(fileext = ".iff")
pt2_write_sample(my_sample, my_sample_file)
}
\author{
Pepijn de Vries
}
