% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procmod_frame.R
\name{procmod_frame}
\alias{procmod_frame}
\title{The procmod_frame data structure.}
\usage{
procmod_frame(..., row_names = NULL, check_rows = TRUE,
  reorder_rows = TRUE, contrasts_arg = NULL)
}
\arguments{
\item{...}{a set of objects to aggregate into a
\code{procmod_frame}. These objects can be
numeric matrices, or dist objects. Every objects
must have the same number of row.}

\item{row_names}{a character vector containing names associated
to each row.}

\item{check_rows}{a logical value. When set to \code{TRUE}, its
default value, the number of row of every elements of the
\code{procmod_frame} are tested for equality. Otherwise no
check is done.}

\item{reorder_rows}{a logical value. When set to \code{TRUE}, its
default value, every elements of the
\code{procmod_frame} are reordered according to the \code{row_names}
order. Otherwise nothing is done.}

\item{contrasts_arg}{A list, whose entries are values
(numeric matrices or character strings naming functions)
to be used as replacement values for the contrasts
replacement function and whose names are the names
of columns of data containing factors.}
}
\value{
a \code{procmod_frame} instance.
}
\description{
A \code{procmod_frame} can be considered as the analog of a
\code{data.frame} for vector data. In a \code{procmod_frame}
each element, equivalent to a column in a \code{data.frame}
is a numeric matrix or a distance matrix object (\code{dist}).
Every element must describe the same number of individuals.
Therefore every numeric matrix must have the same number of row
(\code{nrow}) and every distance matrix must have the same size
(\code{attr(d,"Size")}). A \code{procmod_frame} can simultaneously
contain both types of data, numeric and distance matrix.
}
\examples{
library(vegan)
data(bacteria)
data(eukaryotes)
data(soil)

dataset <- procmod_frame(euk = vegdist(decostand(eukaryotes,
                                                 method = "hellinger"),
                                       method = "euclidean"),
                         bac = vegdist(decostand(bacteria,
                                                 method = "hellinger"),
                                       method = "euclidean"),
                         soil = scale(soil,
                                      center = TRUE,
                                      scale  = TRUE))
length(dataset)
nrow(dataset)
ncol(dataset)
dataset$euk

}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
