% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browseData.R
\name{browseData}
\alias{browseData}
\title{A browse database function}
\usage{
browseData(
  dataset = NULL,
  site = NULL,
  location = NULL,
  variables = FALSE,
  collapse = TRUE
)
}
\arguments{
\item{dataset}{a character string providing the name of the dataset (optional).}

\item{site}{a character string providing the name of the site (optional).}

\item{location}{deprecated argument. Please use site instead.}

\item{variables}{a boolean indicating whether to return the variables of a dataset,
instead of the available sites.}

\item{collapse}{a boolean indicating whether to return the compact (TRUE) or the extended (FALSE)
data overview, if neither site nor dataset are passed to the function.}
}
\value{
\itemize{
   \item if no arguments,  an overview of available data
   \item  if metadata, the requested metadata
   \item  if dataset and variables, available variables for a dataset
   \item  if dataset, available sites for the dataset
   \item  if site, available datasets for a site
   \item  if site and dataset,  returns an integer. Availability is coded as 0 = no available and 1 = available.
    This is the quickest option to check availability.
   }
}
\description{
A function to provide information on available data in the
PROFOUND database.
}
\details{
Besides providing information on available data, this function allows
to access the database metadata, policy,  data sources and site descriptions.
}
\note{
To report errors in the package or the data, please use the issue tracker
in the GitHub repository of ProfoundData \url{https://github.com/COST-FP1304-PROFOUND/ProfoundData}
}
\examples{
# example requires that a sql DB is registered via setDB(dbfile)
# when run without a registered DB, you will get a file query (depending on OS)

\dontrun{
# See available data of the database
overview <- browseData()
# Hint: If *collapse* FALSE, full version of the overview table
overview <- browseData(collapse = FALSE)

# Available datasets
tables <- browseData(dataset = "DATASETS")

# Available variables for a given dataset
variables <- browseData(dataset = "CLIMATE_LOCAL", variables = TRUE)

# Available sites for a given dataset
available <- browseData(dataset = "CLIMATE_LOCAL")

# Available datasets for a given site
available <- browseData(site ="le_bray")

# Whether a dataset is available for a specific site
available <- browseData(site ="le_bray", dataset = "CLIMATE_LOCAL")

# See version history
version <- browseData(dataset = "VERSION")

# See metadata
metadata <- browseData(dataset = "METADATA_DATASETS")
metadata <- browseData(dataset = "METADATA_CLIMATE_LOCAL")

# See metadata of a specific site
metadata <- browseData(dataset = "METADATA_TREE", site = "solling_spruce")

# See data source
source <- browseData(dataset = "SOURCE")

# See data source of a specific site
source <- browseData(dataset = "SOURCE", site = "solling_spruce")

# See data policy
source <- browseData(dataset = "POLICY")

# See data policy of a specific site
policy <- browseData(dataset = "POLICY", site = "solling_spruce")
}
}
\keyword{ProfoundData}
