% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_pert_estocastico_demora.R
\name{delay.stochastic.pert}
\alias{delay.stochastic.pert}
\title{Problems of distribution of delay in stochastic projects}
\usage{
delay.stochastic.pert(precedence, distribution, values, observed.duration,
  percentile = NULL, delta = NULL, compilations = 1000)
}
\arguments{
\item{precedence}{A matrix that indicates the order of precedence between activities. If the value \eqn{(i,j)} is equal to 1 then \eqn{i} precedes \eqn{j}.}

\item{distribution}{Type of distribution that each activities' initial duration has. It can be NORMAL, TRIANGLE, EXPONENTIAL, UNIFORM and EMPIRICAL.}

\item{values}{Matrix with the parameters corresponding to the distribution associated with the duration for each activity. Considering i as an activity we have the following cases. If the distribution is TRIANGLE, then (i, 1) it is the minimum value, (i, 2) the maximum value and (i, 3) the mode. If the distribution is NORMAL, (i, 1) is the mean and (i, 2) the variance. If the distribution is EXPONENTIAL, then (i, 1) is the \eqn{\lambda} parameter. If the distribution is UNIFORM, (i, 1) it is the minimum value and (i, 2) the maximum value. Finally, if the distribution is EMPIRICAL, then (i,j), for all \eqn{j\in \{1,...,M\}} such that \eqn{M>0}, is the sample.}

\item{observed.duration}{Vector with the observed duration for each activity.}

\item{percentile}{Percentile used to calculate the maximum time allowed for the duration of the project (Default=NULL). Only percentile or delta is necessary.}

\item{delta}{Maximum time allowed for the duration of the project (Default=NULL). Only delta or pencetile is necessary.}

\item{compilations}{Number of compilations that the function will use for average calculations (Default=1000).}
}
\value{
A delay value and solution vector.
}
\description{
This function calculates the delay of a stochastic project, once it has been carried out. In addition, it also calculates the distribution of the delay on the different activities with the Stochastic Shapley rule.
}
\details{
Given a problem of sharing delays in a stochastic project \eqn{(N,\prec,\{X_i\}_{i\in N},\{x_i\}_{i\in N})},  such that \eqn{\{X_i\}_{i\in N}} is the random variable of activities' duration and \eqn{\{x_i\}_{i\in N}} the observed value. It is defined as \eqn{E(D(N,\prec,\{X_i\}_{i\in N}))} the expected project time, where \eqn{E} is the mathematical expectation, and \eqn{D(N,\prec,\{x_i\}_{i\in N})} the observed project time, then \eqn{d=D(N,\prec,\{X_i\}_{i\in N})-\delta>0}, with \eqn{\delta>0}, is the delay. The Stochastic Shapley rule is based on the Shapley value for the TU game \eqn{(N,v)} where \eqn{v(S)=E(\max\{D(N,\prec,(\{X_i\}_{i\in N\backslash S},\{x_i\}_{i\in S}))-\delta,0\})}, for all \eqn{S\subseteq N}.  If the number of activities is greater than nine, the Shapley value, of the game \eqn{(N,v)}, is estimated using a unique sampling process for all players, see \cite{Castro et al. (2009)}.
}
\examples{

precedence<-matrix(c(0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0),nrow=5,ncol=5,byrow=TRUE)
distribution<-c("TRIANGLE","TRIANGLE","TRIANGLE","TRIANGLE","TRIANGLE")
values<-matrix(c(1,3,2,1/2,3/2,1,1/4,9/4,1/2,3,5,4,0,4,2),nrow=5,byrow=TRUE)
observed.duration<-c(2.5,1.25,2,4.5,3)
percentile<-NULL
delta<-6.5
delay.stochastic.pert(precedence,distribution,values,observed.duration,percentile,delta)

}
\references{
\describe{
  \item{}{Castro, J., Gómez, D., & Tejada, J. (2009). Polynomial calculation of the Shapley value based on sampling. Computers & Operations Research, 36(5), 1726-1730.}
  \item{}{Gonçalves-Dosantos, J.C., García-Jurado, I., Costa, J. (2018) Sharing delay costs in Stochastic projects.}
}
}
