% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PsychWordVec.R
\name{data_wordvec_normalize}
\alias{data_wordvec_normalize}
\title{Normalize all word vectors to unit length.}
\usage{
data_wordvec_normalize(data, verbose = TRUE)
}
\arguments{
\item{data}{A \code{data.table} (of new class \code{wordvec})
loaded by \code{\link{data_wordvec_load}}.}

\item{verbose}{Print information to the console? Defaults to \code{TRUE}.}
}
\value{
A \code{data.table} (of new class \code{wordvec}) with \strong{normalized} word vectors.
}
\description{
L2-normalization (scaling to unit euclidean length):
the \emph{norm} of each vector in the vector space will be normalized to 1.

R formula: \code{normalized_vec = vec / sqrt(sum(vec^2))}

\emph{Note}: Normalization does not change the results of cosine similarity and
can make the computation faster.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
d = data_wordvec_normalize(demodata)

data_wordvec_normalize(d)  # already normalized

}
\seealso{
\code{\link{data_transform}}

\code{\link{data_wordvec_load}}

\code{\link{data_wordvec_reshape}}

\code{\link{data_wordvec_subset}}
}
