% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWV1_static.R
\name{cosine_similarity}
\alias{cosine_similarity}
\alias{cos_sim}
\alias{cos_dist}
\title{Cosine similarity/distance between two vectors.}
\usage{
cosine_similarity(v1, v2, distance = FALSE)

cos_sim(v1, v2)

cos_dist(v1, v2)
}
\arguments{
\item{v1, v2}{Numeric vector (of the same length).}

\item{distance}{Compute cosine distance instead?
Defaults to \code{FALSE} (cosine similarity).}
}
\value{
A value of cosine similarity/distance.
}
\description{
Cosine similarity/distance between two vectors.
}
\details{
Cosine similarity =

\code{sum(v1 * v2) / ( sqrt(sum(v1^2)) * sqrt(sum(v2^2)) )}

Cosine distance =

\code{1 - cosine_similarity(v1, v2)}
}
\examples{
cos_sim(v1=c(1,1,1), v2=c(2,2,2))  # 1
cos_sim(v1=c(1,4,1), v2=c(4,1,1))  # 0.5
cos_sim(v1=c(1,1,0), v2=c(0,0,1))  # 0

cos_dist(v1=c(1,1,1), v2=c(2,2,2))  # 0
cos_dist(v1=c(1,4,1), v2=c(4,1,1))  # 0.5
cos_dist(v1=c(1,1,0), v2=c(0,0,1))  # 1

}
\seealso{
\code{\link{pair_similarity}}

\code{\link{tab_similarity}}

\code{\link{most_similar}}
}
