% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWV1_static.R
\name{plot_wordvec}
\alias{plot_wordvec}
\title{Visualize word vectors.}
\usage{
plot_wordvec(x, dims = NULL, step = 0.05, border = "white")
}
\arguments{
\item{x}{Can be:
\itemize{
  \item{a \code{data.table} returned by \code{\link{get_wordvecs}}}
  \item{a \code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table)
  or \code{\link[PsychWordVec:as_embed]{embed}} (matrix)
  loaded by \code{\link{data_wordvec_load}}}
}}

\item{dims}{Dimensions to be plotted (e.g., \code{1:100}).
Defaults to \code{NULL} (plot all dimensions).}

\item{step}{Step for value breaks. Defaults to \code{0.05}.}

\item{border}{Color of tile border. Defaults to \code{"white"}.
To remove the border color, set \code{border=NA}.}
}
\value{
A \code{ggplot} object.
}
\description{
Visualize word vectors.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
d = as_wordvec(demodata, normalize=TRUE)

plot_wordvec(d[1:10])
plot_wordvec(as_embed(d[1:10]))

\donttest{dt = get_wordvecs(d, cc("king, queen, man, woman"))
dt[, QUEEN := king - man + woman]
dt[, QUEEN := QUEEN / sqrt(sum(QUEEN^2))]  # normalize
names(dt)[5] = "king - man + woman"
plot_wordvec(dt[, c(1,3,4,5,2)], dims=1:50)

dt = get_wordvecs(d, cc("boy, girl, he, she"))
dt[, GIRL := boy - he + she]
dt[, GIRL := GIRL / sqrt(sum(GIRL^2))]  # normalize
names(dt)[5] = "boy - he + she"
plot_wordvec(dt[, c(1,3,4,5,2)], dims=1:50)

dt = get_wordvecs(d, cc("
  male, man, boy, he, his,
  female, woman, girl, she, her"))

p = plot_wordvec(dt, dims=1:100)

# if you want to change something:
p + theme(legend.key.height=unit(0.1, "npc"))

# or to save the plot:
ggsave(p, filename="wordvecs.png",
       width=8, height=5, dpi=500)
unlink("wordvecs.png")  # delete file for code check
}
}
\seealso{
\code{\link{plot_wordvec_tSNE}}
}
