% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgm-Stanley2017.R
\name{dgm.Stanley2017}
\alias{dgm.Stanley2017}
\title{Stanley, Doucouliagos, and Ioannidis (2017) Data-Generating Mechanism}
\usage{
\method{dgm}{Stanley2017}(dgm_name, settings)
}
\arguments{
\item{dgm_name}{DGM name (automatically passed)}

\item{settings}{List containing \describe{
\item{environment}{Type of the simulation environment. One of
\code{"logOR"} or \code{"SMD"}.}
\item{mean_effect}{Mean effect}
\item{effect_heterogeneity}{Mean effect heterogeneity}
\item{bias}{Proportion of studies affected by publication bias}
\item{n_studies}{Number of effect size estimates}
\item{sample_sizes}{Sample sizes of the effect size estimates. A vector of
sample sizes needs to be supplied. The sample sizes in the vector are
sequentially reused until all effect size estimates are generated.}
}}
}
\value{
Data frame with \describe{
\item{yi}{effect size}
\item{sei}{standard error}
\item{ni}{sample size}
\item{es_type}{effect size type}
}
}
\description{
Simulates two scenarios for meta-analysis studies investigating the effect
of a treatment in:
(1) Log Odds Ratio scenario, where the outcome is binary and effect
heterogeneity is controlled by a random component, and
(2) Cohen's d scenario, where the outcome is continuous and effect
heterogeneity is introduced through a random component.
Both scenarios allow for varying sample sizes and publication selection
regimes, affecting the inclusion of study estimates based on their
statistical significance and sign.

The description and code is based on
\insertCite{hong2021using;textual}{PublicationBiasBenchmark}.
The data-generating mechanism was introduced in
\insertCite{stanley2017finding;textual}{PublicationBiasBenchmark}.
}
\details{
This function simulates two meta-analysis scenarios to evaluate the effect
of a binary treatment variable (\verb{treat = \{0, 1\}}) on study outcomes,
incorporating both effect heterogeneity and publication selection mechanisms.

In the Log Odds Ratio (\code{"logOR"}) scenario, primary studies assess the
impact of treatment on a binary success indicator (\code{Y = 1}). The control
group has a fixed 10\% probability of success, while the treatment group's
probability is increased by a fixed effect and a mean-zero random component,
whose variance (sigma2_h) controls effect heterogeneity. Each study estimates a
logistic regression, with the coefficient on \code{treat} (alpha1) as the effect of
interest. Study sample sizes vary, resulting in different standard errors
for estimated effects.

In the Cohen's d (\code{"SMD"}) scenario, the outcome variable is
continuous. The treatment effect is modeled as a fixed effect (alpha1) plus a
random component (variance sigma2_h). Each study computes Cohen's d, the
standardized mean difference between treatment and control groups. Study
sample sizes vary, affecting the standard errors of d.

Publication selection is modeled in two regimes: (1) no selection, and
(2) 50\% selection. Under 50\% selection, each estimate has a 50\% chance of
being evaluated for inclusion. If selected, only positive and statistically
significant estimates are published; otherwise, new estimates are generated
until this criterion is met. This process continues until the meta-analyst’s
sample reaches its predetermined size.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=dgm]{dgm()}}, \code{\link[=validate_dgm_setting]{validate_dgm_setting()}}
}
