% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-EK.R
\name{method.EK}
\alias{method.EK}
\title{Endogenous Kink Method}
\usage{
\method{method}{EK}(method_name, data, settings = NULL)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (no settings version are implemented)}
}
\value{
Data frame with EK results
}
\description{
Implements the endogenous kink (EK) method proposed by Bom and Rachinger for
publication bias correction in meta-analysis. This method modifies the PET-PEESE
approach by incorporating a non-linear relationship between publication bias and
standard errors through a kinked regression specification. The method recognizes
that when the true effect is non-zero, there is minimal publication selection
when standard errors are very small (since most estimates are significant), but
selection increases as standard errors grow. The kink point is endogenously
determined using a two-step procedure based on the confidence interval of the
initial effect estimate. See
\insertCite{bom2019kinked;textual}{PublicationBiasBenchmark} for details.
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply EK method
result <- run_method("EK", data)
print(result)

}
\references{
\insertAllCited{}
}
