% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.riskRegression.R
\name{publish.riskRegression}
\alias{publish.riskRegression}
\title{Publishing results of riskRegression}
\usage{
\method{publish}{riskRegression}(object, digits = c(2, 4),
  print = TRUE, ...)
}
\arguments{
\item{object}{object of class riskRegression as obtained with
functions ARR and LRR.}

\item{digits}{Number of digits for regression coefficients}

\item{print}{If \code{FALSE} do not print the results}

\item{...}{passed to \code{\link{publish.matrix}}}
}
\value{
Table with regression coefficients, confidence intervals and p-values
}
\description{
Preparing a publishable table from riskRegression results
}
\examples{
library(prodlim)
library(riskRegression)
library(lava)
library(survival)
set.seed(20)
d <- SimCompRisk(20)
f <- ARR(Hist(time,event)~X1+X2,data=d,cause=1)
publish(f)
publish(f,digits=c(1,3))
}
\seealso{
ARR LRR
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
