% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splinePlot.lrm.R
\name{splinePlot.lrm}
\alias{splinePlot.lrm}
\title{Plot predictions of logistic regression}
\usage{
splinePlot.lrm(object, xvar, xvalues, xlim = range(xvalues), ylim,
  xlab = xvar, ylab = scale[[1]], col = 1, lwd = 3,
  confint = TRUE, newdata = NULL, scale = c("risk", "odds"),
  add = FALSE, ...)
}
\arguments{
\item{object}{Logistic regression model fitted with \code{rms::lrm}}

\item{xvar}{Name of the variable to show on x-axis}

\item{xvalues}{Sequence of \code{xvar} values}

\item{xlim}{x-axis limits}

\item{ylim}{y-axis limits}

\item{xlab}{x-axis labels}

\item{ylab}{y-axis labels}

\item{col}{color of the line}

\item{lwd}{line width}

\item{confint}{Logical. If \code{TRUE} show confidence shadows}

\item{newdata}{How to adjust}

\item{scale}{Character string that determines the outcome scale (y-axis). Choose between \code{"risk"} and \code{"odds"}.}

\item{add}{Logical. If \code{TRUE} add lines to an existing graph}

\item{...}{Further arguments passed to \code{plot}. Only if \code{add} is \code{FALSE}.}
}
\description{
Plotting the prediction of a logistic regression model
with confidence bands against one continuous variable.
}
\details{
Function which extracts from a logistic regression model
fitted with \code{rms::lrm} the predicted risks or odds.
}
\examples{
data(Diabetes)
Diabetes$hypertension=  1*(Diabetes$bp.1s>140)
library(rms)
uu <- datadist(Diabetes)
options(datadist="uu")
fit=lrm(hypertension~rcs(age)+gender+hdl,data=Diabetes)
splinePlot.lrm(fit,xvar="age",xvalues=seq(30,50,1))
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
