% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApiData.R
\encoding{UTF8}
\name{ApiData}
\alias{ApiData}
\title{PX-Web Data by API}
\usage{
ApiData(urlToData, ..., getDataByGET = FALSE, returnMetaData = FALSE,
  returnMetaValues = FALSE, returnApiQuery = FALSE,
  defaultJSONquery = c(1, -2, -1), verbosePrint = FALSE,
  use_factors = FALSE, urlType = "SSB")
}
\arguments{
\item{urlToData}{url to data or id of SSB data}

\item{...}{specification of JSON query for each variable}

\item{getDataByGET}{When TRUE, readymade dataset by GET - works only for Statistics Norway readymade datasets}

\item{returnMetaData}{When TRUE, metadata returned}

\item{returnMetaValues}{When TRUE, values from metadata returned}

\item{returnApiQuery}{When TRUE, JSON query returned}

\item{defaultJSONquery}{specification for variables not included in ...}

\item{verbosePrint}{When TRUE, printing to console}

\item{use_factors}{Parameter to \code{\link{fromJSONstat}} defining whether dimension categories should be factors or character objects.}

\item{urlType}{Parameter defining how url is constructed from id number. Currently two Statistics Norway possibilities: "SSB" (Norwegian) or "SSBen" (English)}
}
\value{
list of two data sets (label and id)
}
\description{
A function to read PX-Web data into R via API. The example code reads data from the three national statistical institutes, Statistics Norway, Statistics Sweden and Statistics Finland.
}
\details{
Each variable is specified by using the variable name as input parameter. The value can be specified as:  
TRUE (all), FALSE (eliminated), imaginary value (top), original variable values or variable indices. Reversed 
indices can be specified as negative values. Indices outside the range are removed. Variables not specified 
is set to the value of defaultJSONquery whose default means the first and the two last elements. 

The value can also be specified as a (unnamed) two-element list corresponding to the two 
query elements, filter and values. I addition it possible with a single-element list.
Then filter is set to 'all'. See examples.
}
\examples{
\dontrun{

##### Readymade dataset by GET - works only for Statistics Norway readymade datasets
x <- ApiData("http://data.ssb.no/api/v0/dataset/1066.json?lang=en", getDataByGET = TRUE)
x[[1]]  # The label version of the data set
x[[2]]  # The id version of the data set

##### Special output
ApiData("http://data.ssb.no/api/v0/en/table/09941", returnMetaData = TRUE)  # meta data
ApiData("http://data.ssb.no/api/v0/en/table/09941", returnMetaValues = TRUE)  # meta data values
ApiData("http://data.ssb.no/api/v0/en/table/09941", returnApiQuery = TRUE)  # Query using defaults

##### Ordinary use

# Two specified and the last is default
ApiData("http://data.ssb.no/api/v0/en/table/09941", NACE2007 = 0+10i, ContentsCode = TRUE)

# Two specified and the last is default – in Norwegian change en to no in url
ApiData("http://data.ssb.no/api/v0/no/table/09941", NACE2007 = 0+10i, ContentsCode = TRUE)


# Number of residents (bosatte) last year, each region
ApiData("http://data.ssb.no/api/v0/en/table/04861", Region = TRUE, 
        ContentsCode = "Bosatte", Tid = 0+1i)

# Number of residents (bosatte) each year, total
ApiData("http://data.ssb.no/api/v0/en/table/04861", Region = FALSE, 
        ContentsCode = "Bosatte", Tid = TRUE)

# Some years
ApiData("http://data.ssb.no/api/v0/en/table/04861", Region = FALSE, 
        ContentsCode = "Bosatte", Tid = c(1, 5, -1))

# Two selected regions
ApiData("http://data.ssb.no/api/v0/en/table/04861", Region = c("0811", "0301"), 
        ContentsCode = 1, Tid = c(1, -1))



##### Advanced use using list
ApiData("http://data.ssb.no/api/v0/en/table/04861", Region = list("03*"), 
        ContentsCode = 1, Tid = 0+5i)
ApiData("http://data.ssb.no/api/v0/en/table/04861", Region = list("all", "03*"), 
        ContentsCode = 1, Tid = 0+5i)
ApiData("http://data.ssb.no/api/v0/en/table/04861", Region = list("filter", c("0811", "0301")), 
        ContentsCode = 1, Tid = 0+5i)

##### Using id instead of url, unnamed input and verbosePrint
ApiData(4861, c("0811", "0301"), 1, c(1, -1))
ApiData("4861", c("0811", "0301"), 1, c(1, -1),  urlType="SSBen")
ApiData("04861", c("0811", "0301"), 1, c(1, -1), verbosePrint = TRUE)
ApiData(1066, getDataByGET = TRUE,  urlType="SSB")
ApiData(1066, getDataByGET = TRUE,  urlType="SSBen")

##### Data from SCB and Statfi:
ApiData("http://api.scb.se/OV0104/v1/doris/sv/ssd/BE/BE0101/BE0101A/BefolkningNy")
ApiData("http://pxnet2.stat.fi/PXWeb/api/v1/en/StatFin/vrm/kuol/statfin_kuol_pxt_010.px")
         
}
}
