% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemgen_function.R
\name{itemgen}
\alias{itemgen}
\title{Automatic Item Generator for Quantitative Multiple-Choice Items}
\usage{
itemgen(stem_text = stem_text, formulae = formulae, N = N, C,
  options_affix, ans_key, save.csv)
}
\arguments{
\item{stem_text}{The stem of the parent item with specified number-variables and character-variables.}

\item{formulae}{A raw text that contains necessary formulae for the options (response choices) along
with necessary values or functions that help to calculate the numeric value for each option.}

\item{N}{A list of numeric input vector(s) for the number variable(s) in the stem.}

\item{C}{(Optional) A list of character input vector(s) for the character variable(s) in the stem if there is any.}

\item{options_affix}{(Optional) A list that consists of vectors with prefixes and suffixes (if there is any) of the
numeric values in the options along with any text that can be included as an option with the item.}

\item{ans_key}{(Optional) A text that indicates the correct response if it is not specified within formulae by '~'.}

\item{save.csv}{(Optional) A name text given by the user for the output .csv file, if user wants to save the newly
generated sibling items in working directory as a data.frame.}
}
\value{
This function returns a data frame that contains stem, options, answer
key etc. for all the generated sibling items within its rows to display in console
and within its columns if the argument 'save.csv' is not missing in the function.
}
\description{
\code{itemgen} function generates group of sibling items from a
parent item model defined by user.
}
\details{
User has to develop a short schema that contains formation of stem
(question text) along with response choices (formulae) of the parent item as an
input. Number-variables and character-variables must be specified in special
manner in the stem. \code{itemgen} function delivers the changes in the positions
of the variables in stem and calculates the response choices automatically by
taking members from the input vectors given by user in the schema. As a result,
several permutations of changes in the variables lead to generation of
new group of items.
}
\note{
The formula model for each option must be distinct. Otherwise this
program will throw an error. If same numeric value needs to be produced in many
options, those models can be made different by adding 0 or multiplying 1
with the terms in the model.

The model for the distractor options in formulae must be written using "?".
Correct response option can be written using EITHER "~" OR "?". In OR case correct
response must be indicated by the function argument "ans_key" to stop this \code{itemgen}
function throw an error.
}
\examples{
stem_text <- "What is the sum of first [n1] [c1] ?"
n1 <- c(5, 8, 11, 14, 17)
c1 <- c("natural numbers", "non-zero positive integers")
N <- list(n1 = n1)
C <- list(c1 = c1)
formulae <- "Option_A ? 2*n1-1\\nOption_B ? 3*n1-2\\nOption_C ? n1*(n1+1)/2\\nOption_D ? n1*(n1-1)/2\\n"
options_affix <- list(Option_A = c("Sum value = ", ""), Option_B = c("Sum value = ", ""),
Option_C = c("Sum value = ", ""), Option_D = c("Sum value = ", ""))

itemgen(stem_text = stem_text, formulae = formulae, N = N, C = C, ans_key = "Option_C",
options_affix = options_affix)


}
\references{
\url{https://www.researchgate.net/publication/239794821_The_Role_of_Item_Models_in_Automatic_Item_Generation}
Mark J. Gierl, Hollis Lai
The Role of Item Models in Automatic Item Generation (2011)

\url{https://onlinelibrary.wiley.com/doi/epdf/10.1111/jedm.12166}
Susan E. Embretson,  Neal M. Kingston
Automatic Item Generation: A More Efficient Process for Developing Mathematics Achievement Items? (2018)
}
\author{
Shubh Patra and Bao Sheng Loe
}
