% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GETF.R
\name{mleGTEF}
\alias{mleGTEF}
\title{Maximum likelihood estimation (MLE) for the generalized tick-exponential family (GTEF) of distributions.}
\usage{
mleGTEF(y, g, lower = -Inf, upper = Inf)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{g}{This is the "link" function. The function \eqn{g} is to be differentiated. Therefore, \eqn{g} must be written as a function. For example, {g<-function(y)\{log(y)\}} for log link function.}

\item{lower}{This is the lower limit of the domain (support of the random variable) \eqn{f_{\alpha}^g(y;\eta,\phi)}, default {-Inf}.}

\item{upper}{This is the upper limit of the domain (support of the random variable) \eqn{f_{\alpha}^g(y;\eta,\phi)}, default {Inf}.}
}
\value{
The maximum likelihood estimate of parameter \eqn{\theta=(\eta,\phi,\alpha,p)} of the generalized tick-exponential family of distributions.
}
\description{
The log-likelihood function \eqn{\ell_n(\eta,\phi,\alpha,p)=\ln[L_n(\eta,\phi,\alpha,p)]}
and parameter estimation of \eqn{ \theta=(\eta,\phi,\alpha,p)} in the generalized tick-exponential family of distributions
by using the maximum likelihood estimation are discussed in Gijbels et al. (2019b).
}
\examples{
# Example
rnum=rnorm(100)
g_id<-function(y){y}
g_log<-function(y){log(y)}
mleGTEF(rnum,g_id) # For identity-link
mleGTEF(rexp(100),g_log,lower = 0, upper = Inf) # For log-link
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019b). Quantile estimation in a generalized  asymmetric distributional setting. To appear in \emph{Springer Proceedings in Mathematics & Statistics, Proceedings of `SMSA 2019', the 14th Workshop on Stochastic Models, Statistics and their Application}, Dresden, Germany, in March 6--8, 2019. Editors: Ansgar Steland, Ewaryst Rafajlowicz, Ostap Okhrin.
}
}
