% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_hwsd2}
\alias{get_hwsd2}
\title{Get HWSD v2 Soil Data for a Given Location(s)}
\usage{
get_hwsd2(df, con, x = "longitude", y = "latitude", sequence = 1, layer = "D1")
}
\arguments{
\item{df}{data.frame that list locations info including the coordinates in decimal degree format.}

\item{con}{the HWSDv2 object returns from the ini_hwsd2() function.}

\item{x}{longitude column name in the df data.frame (default is 'Longitude').}

\item{y}{latitude column name in the df data.frame (default is 'Latitude').}

\item{sequence}{the sequence in which soil units are presented (in order of percentage share). 
The dominant soil has sequence 1. The sequence can range between 1 and 12.}

\item{layer}{the depth layer range from 'D1' to 'D7'. The depth of the top and bottom of 
each layer is defined in the TOPDEP and BOTDEP columns, respectively.}
}
\description{
The HWSD2_SMU table contains general information for each of the soil units 
occurring in any given SMU code (dominant soil unit and up to 11 associated soils).

The SEQUENCE column refers to the sequence in which soil units within the SMU 
are presented (in order of percentage share). The dominant soil has sequence 1. 
The sequence can range between 1 and 12.

The SHARE column refers to the share of the soil unit within the mapping unit in 
percentage. Shares of soil units within a mapping unit always sum up to 100 percent.

The HWSD2_LAYERS table provides soil attributes per depth layer for each of the 
seven depth layers (D1 to D7) separately (represented in the LAYER column in the 
HWSD2_LAYERS table). The depth of the top and bottom of each layer is defined in
the TOPDEP and BOTDEP columns, respectively.
}
\examples{
if (interactive()) {
  # create a simple data.frame for a list of locations and their coordinates
  Location  <- c('Tel-Hadya', 'Terbol', 'Marchouch')
  Latitude  <- c(36.016, 33.808, 33.616)
  Longitude <- c(36.943, 35.991, -6.716)
  
  sites <- data.frame(Location, Latitude, Longitude)
  
  # initiate, download, and setup the HWSD v2 in a given local directory
  hwsd2 <- ini_hwsd2(data_path = 'C:/Users/Kel-shamaa/Downloads/HWSD v2/')
  
  # query soil attributes for given sites using the HWSD v2 connection object
  #
  # sequence parameter, range between 1 and 12 (max), 1 is the dominant soil.
  # returned df has SHARE column refers to share\%
  #
  # layer parameter refers to depth layer (D1 to D7).
  # returned df has TOPDEP/BOTDEP columns represent top/bottom layer depth in cm.
  sites <- get_hwsd2(df = sites, 
                     con = hwsd2, 
                     x = 'Longitude', 
                     y = 'Latitude', 
                     sequence = 1, 
                     layer = 'D1')
}
}
\seealso{
\code{\link{ini_hwsd2}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
