% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gigwa.R
\name{gigwa_get_sequences}
\alias{gigwa_get_sequences}
\title{Get the Sequences of the Current Active GIGWA Project}
\usage{
gigwa_get_sequences()
}
\value{
A vector of sequence names (e.g., chromosome names) for the selected project.
}
\description{
Retrieve the list of sequences (e.g., chromosomes) associated with the currently
active project in GIGWA, which has been set using the `gigwa_set_project()` function.
}
\examples{
if (interactive()) {
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                  time_out = 300, engine = "gigwa", no_auth = TRUE)
  gigwa_set_db("Sorghum-JGI_v1")
  gigwa_set_project("Nelson_et_al_2011")
  chroms <- gigwa_get_sequences()
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_set_project}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
