% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/p.threshold.adjust.R
\name{p.threshold.adjust}
\alias{p.threshold.adjust}
\title{Calculate Vector of p-value Thresholds for Multiple Inference}
\usage{
p.threshold.adjust(total.configs, my.method)
}
\arguments{
\item{total.configs}{The total number of hypotheses tested, or the number of
configurations utilized by the Quine-McCluskey algorithm in fsQCA (including
logical remainders, if they are used in the analysis).}

\item{my.method}{The adjustment method used to calculate p-values (see
\code{\link{p.adjust}} for details).}
}
\value{
Numeric vector giving adjusted p-value thresholds, from smallest to
largest.
}
\description{
Internal function. Calculates the adjusted thresholds for multiple significance
tests, assuming that the original threshold for a single test is p<0.05.
Used by \code{\link{fsQCApermTest}} to calculate confidence intervals.
}
\examples{
p.threshold.adjust(10, "holm")
}
\keyword{fsQCA}
\keyword{p-value}
\keyword{threshold}

