% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_Rep_Code.R
\name{comp.rep}
\alias{comp.rep}
\title{Repeatability in Diet Estimates}
\usage{
comp.rep(
  data,
  prey.database,
  fatcont.mat,
  dist.meas,
  ext.fa,
  B = 50,
  R = 100,
  CI = FALSE,
  alpha = 0.05,
  gamma.QFASA = 1,
  gamma.rho = 1
)
}
\arguments{
\item{data}{data frame of diet estimates. First column must denote the predator
and second column the second factor (eg. year or season).}

\item{prey.database}{prey data base that was used to compute the QFASA diet
estimates in \code{data}. Will be used to generate pseudo predators.}

\item{fatcont.mat}{data frame or matrix of length equal to the number of prey
FA signatures in prey data base.  First column is name of species and
second column is lipid.}

\item{dist.meas}{distance measure to use in \code{p.QFASA}.}

\item{ext.fa}{subset of FAs to use.}

\item{B}{number of pseudo predators samples to generate for bias calculation.
Default is set to 50 because is slow to run.}

\item{R}{number of bootstrap samples (i.e. \code{R} samples for each generated sample
of pseudo predators). Default is set to 100 because it is slow to run.}

\item{CI}{indicates if a confidence interval for rho is to be calculated.
Default is FALSE since this is time consuming to obtain.}

\item{alpha}{a (1-alpha/2)X100 percent confidence interval is calculated for rho
if \code{CI=TRUE}.}

\item{gamma.QFASA}{if \code{dist.meas=3}, gamma is required.  Default is 1.}

\item{gamma.rho}{value of gamma to be used to compute CS distance
in repeatablity functions.  Default is 1.}
}
\value{
Bias corrected measure of repeatability, estimate of the bias and
     (if \code{CI=TRUE}) a confidence interval for the true repeatability.
}
\description{
Computes a measure of repeatability for a sample of predators with repeated
diet estimate measurements.
}
\examples{

 ##  These examples take some time to run.
 ##  Please uncomment code below to run them.

# data(preyFAs)
# data(FAset)

## Balanced Diet Data

#my.preybase <- preyFAs[,-c(1,3)]
#my.preybase[,-1] <- my.preybase[,-1]/rowSums(my.preybase[,-1])

#set.seed(10)

#comp.rep(data = bal.diet.data,prey.database=my.preybase,
#fatcont.mat = as.data.frame(preyFAs[,c(2,3)]),dist.meas=2,
#ext.fa = as.vector(unlist(FAset)))

## Unbalanced Diet Data

# my.preybase <- preyFAs[,-c(1,3)]
# my.preybase[,-1] <- my.preybase[,-1]/rowSums(my.preybase[,-1])

# set.seed(10)

# comp.rep(unbal.diet.data,my.preybase,as.data.frame(preyFAs[,c(2,3)]),2,
# as.vector(unlist(FAset)))
}
\references{
"Repeatability for Compositional Diet Estimates with Zeros".
Contact Connie Stewart (cstewart@unb.ca).
}
