% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QFRM.R
\name{BOPM_Eu}
\alias{BOPM_Eu}
\title{European option valuation (vectorized computation).}
\usage{
BOPM_Eu(o = OptPx())
}
\arguments{
\item{o}{An \code{OptPx} object}
}
\value{
A list of class \code{OptPx} with an element \code{PxBT}, which is an option price value (type \code{double}, class \code{numeric})
}
\description{
A helper function to price European options via a vectorized (fast, memory efficient) approach.
}
\examples{
#Fig.13.11, Hull/9e/p291:
o = Opt(Style='European', Right='Call', S0=810, ttm=.5, K=800)
(o <- BOPM_Eu( OptPx(o, r=.05, q=.02, vol=.2, n=2)))$PxBT

o = Opt('Eu', 'C', 0.61, .5, 0.6, SName='USD/AUD')
o = OptPx(o, r=.05, q=.02, vol=.12, n=2)
(o <- BOPM_Eu(o))$PxBT
}
\author{
Oleg Melnikov, Department of Statistics, Rice University, Spring 2015
Code adopted Gilli & Schumann's R implementation to \code{Opt*} objects
}
\references{
Gili, M. and Schumann, E. (2009) \emph{Implementing Binomial Trees}, COMISEF Working Papers Series
}
\seealso{
\url{http://papers.ssrn.com/sol3/papers.cfm?abstract_id=1341181} for original paper, \code{\link{BOPM}} for American option pricing.
}

