% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QPBoot-class.R
\name{QPBoot-constructor}
\alias{QPBoot-constructor}
\alias{qpBoot}
\title{qpBoot}
\usage{
qpBoot(data, model = getARMA(list(ar.order = 2, ma.order = 0)),
  levels = c(0.1, 0.5, 0.9), frequencies = 2 * pi/length(data) *
  0:(length(data) - 1), weight = kernelWeight(bw = 0.1), SimNum = 1000,
  fix.param = NULL)
}
\arguments{
\item{data}{numeric vector, containing the time-series data}

\item{model}{an object from the class \link{tsModel-class}.}

\item{levels}{numeric vector containing values between 0 and 1 for which the 
\link[quantspec]{smoothedPG}. Will be estimated. These are the
quantiles levels that are used for the validation}

\item{frequencies}{a vector containing frequencies at which to determine the smoothed periodogram.}

\item{weight}{an object of the class \link[quantspec]{KernelWeight} that is used to
in the estimation of the \link[quantspec]{smoothedPG}.}

\item{SimNum}{number of bootstrap}

\item{fix.param}{defaults to \code{NULL}. In this case the parameters for the simulations are
estimated via the methode defined in the argument \code{model}. If this is not
\code{NULL}, it has to contain a list that can be used to set the parameters
in the \link{tsModel-class}. All simulations are then done with these fixed parameters.}
}
\description{
Create an instance of the \code{QPBoot} class by doing 3 things
\enumerate{
 \item Estimates a parametric \code{model} from a given set of \code{data},
       this estimate can be overwritten by using the parameter \code{fix.param}
 \item Simulates from that \code{model} and computes the smoothed Quantile
       Periodogram (\link[quantspec]{smoothedPG}) for each simulated time
       series and the given \code{data}
 \item Returns an object of the class \link{QPBoot} with the calculated
       smoothed Periodograms
}
}
\keyword{Constructors}
