% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VecDecomVec.R
\name{VecDecomVec}
\alias{VecDecomVec}
\title{Vector decomposition and remainder fields}
\usage{
VecDecomVec(x.num.steps, y.num.steps, x.rhs, y.rhs, x.bound, y.bound)
}
\arguments{
\item{x.num.steps}{The number of steps between the minimum and maximum x value defined in x range.}

\item{y.num.steps}{The number of steps between the minimum and maximum y value defined in y range.}

\item{x.rhs}{A string containing the right hand side of the equation for x.}

\item{y.rhs}{A string containing the right hand side of the equation for y.}

\item{x.bound}{two-element vector with respective minimum and maximum x values.}

\item{y.bound}{two-element vector with respective minimum and maximum y values.}
}
\description{
This function calculates the vector field.
}
\examples{
# First, the system of equations
	equationx <- "1.54*x*(1.0-(x/10.14)) - (y*x*x)/(1.0+x*x)"
	equationy <- "((0.476*x*x*y)/(1+x*x)) - 0.112590*y*y"

# Second, shared parameters for each quasi-potential run
	xbounds <- c(-0.5, 20.0)
	ybounds <- c(-0.5, 20.0)
	xstepnumber <- 1000
	ystepnumber <- 1000

# Third, create the deterministic skeleton vector field
	VDV <- VecDecomVec(x.num.steps = xstepnumber, y.num.steps = ystepnumber, x.rhs = equationx,
	y.rhs = equationy, x.bound = xbounds, y.bound = ybounds)
}

