% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq.test.lvsl_1.R
\name{dq.test.lvsl_1}
\alias{dq.test.lvsl_1}
\title{Sequential Test for Additional Breaks within a Range of Quantiles}
\usage{
dq.test.lvsl_1(y, x, q.L, q.R, n.size = 1, vec.date)
}
\arguments{
\item{y}{A numeric vector of dependent variables (\eqn{NT \times 1}).}

\item{x}{A numeric matrix of regressors (\eqn{NT \times p}).}

\item{q.L}{A numeric value specifying the lower bound of the quantile range.}

\item{q.R}{A numeric value specifying the upper bound of the quantile range.}

\item{n.size}{An integer specifying the size of cross-sections (\eqn{N}).}

\item{vec.date}{A numeric vector (\eqn{L \times 1}) of estimated break dates under the null hypothesis.}
}
\value{
A numeric value representing the DQ test statistic.
}
\description{
This function performs a sequential test to determine whether the number of
breaks in a quantile regression model should be increased from \eqn{L} to \eqn{L+1} using
multiple quantiles.
}
\details{
This procedure tests for the existence of \eqn{L} breaks against \eqn{L+1} breaks
based on multiple quantiles:
\eqn{H_0: L} breaks vs. \eqn{H_1: L+1} breaks.
}
\examples{
# Load data
data(gdp)
y = gdp$gdp
x = gdp[,c("lag1", "lag2")]

# Set quantile range (left and right limits)
q.L = 0.2
q.R = 0.8

# Set N parameter
n.size = 1

# Specify break date under H_0
vec.date = 146

# Run the test
result = dq.test.lvsl_1(y, x, q.L, q.R, n.size, vec.date)
print(result)

}
\references{
Qu, Z. (2008). Testing for Structural Breaks in Regression Quantiles.
\emph{Journal of Econometrics}, 146(1), 170-184.
}
