% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Quandl.R
\name{Quandl}
\alias{Quandl}
\title{Retrieves Data from the Quandl Dataset endpoint and formats}
\usage{
Quandl(code, type = c("raw", "ts", "zoo", "xts", "timeSeries"),
  transform = c("", "diff", "rdiff", "normalize", "cumul", "rdiff_from"),
  collapse = c("", "daily", "weekly", "monthly", "quarterly", "annual"),
  order = c("desc", "asc"), meta = FALSE, force_irregular = FALSE,
  ...)
}
\arguments{
\item{code}{Dataset code on Quandl specified as a string or an array of strings.}

\item{type}{Type of data returned specified as string. Can be 'raw', 'ts', 'zoo', 'xts' or 'timeSeries'.}

\item{transform}{Apply Quandl API data transformations.}

\item{collapse}{Collapse frequency of Data.}

\item{order}{Select if data is given to R in ascending or descending formats. Helpful for the rows parameter.}

\item{meta}{Adds meta data as an attribute to the returned Data.}

\item{force_irregular}{When set to TRUE, forces the index of the Data to be of date format yyyy-mm-dd}

\item{...}{Additional named values that are interpreted as Quandl API parameters. Please see \url{https://www.quandl.com/docs/api#retrieve-data-and-metadata} for a full list of parameters.}
}
\value{
Depending on the type the class is either data.frame, time series, xts, zoo or timeSeries.
}
\description{
Retrieves Data from the Quandl Dataset endpoint and formats
}
\details{
Set your \code{api_key} with \code{Quandl.api_key} function. For instructions on finding your api key go to \url{https://www.quandl.com/account/api}.
}
\examples{
\dontrun{
quandldata = Quandl("NSE/OIL", collapse="monthly", start_date="2013-01-01", type="ts")
plot(quandldata[,1])
}
}
\references{
This R package uses the Quandl API. For more information go to \url{https://www.quandl.com/docs/api}. For more help on the package itself go to \url{https://www.quandl.com/help/r}.
}
\seealso{
\code{\link{Quandl.api_key}}
}
