% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_RollRange.R
\name{RollRange}
\alias{RollRange}
\title{C++ Rolling Range / Quantile class}
\arguments{
\item{n}{indicator period}

\item{p}{probability value \code{[0, 1]}}
}
\description{
C++ class documentation
}
\details{
R functions \link{roll_range}, \link{roll_quantile}, \link{roll_min}, \link{roll_max}.
}
\section{Usage}{
 \code{RollRange( int n, double p = 0.5 )}
}

\section{Public Members and Methods}{

\tabular{lll}{
\cr \strong{Name}                 \tab \strong{Return Type}        \tab \strong{Description}
\cr \code{Add( InputType value )} \tab \code{void}                 \tab update indicator
\cr \code{Reset()}                \tab \code{void}                 \tab reset to initial state
\cr \code{IsFormed()}             \tab \code{bool}                 \tab is indicator value valid?
\cr \code{GetValue()}             \tab \code{Range}                \tab has members \code{double min, max, quantile}
\cr \code{GetMinHistory()}        \tab \code{std::vector< double >}\tab return min history
\cr \code{GetMaxHistory()}        \tab \code{std::vector< double >}\tab return max history
\cr \code{GetQuantileHistory()}   \tab \code{std::vector< double >}\tab return quantile history
\cr \code{GetHistory()}           \tab \code{List}                 \tab return values history data.table with columns \code{min, max}
}
}

\seealso{
Other C++ indicators: \code{\link{BBands}},
  \code{\link{Crossover}}, \code{\link{Ema}},
  \code{\link{Indicator}}, \code{\link{RollLinReg}},
  \code{\link{RollPercentRank}}, \code{\link{RollSd}},
  \code{\link{RollVolumeProfile}}, \code{\link{Rsi}},
  \code{\link{Sma}}, \code{\link{Stochastic}}

Other C++ classes: \code{\link{BBands}},
  \code{\link{Candle}}, \code{\link{Cost}},
  \code{\link{Crossover}}, \code{\link{Ema}},
  \code{\link{Indicator}}, \code{\link{Order}},
  \code{\link{Processor}}, \code{\link{RollLinReg}},
  \code{\link{RollPercentRank}}, \code{\link{RollSd}},
  \code{\link{RollVolumeProfile}}, \code{\link{Rsi}},
  \code{\link{Sma}}, \code{\link{Stochastic}},
  \code{\link{Tick}}
}
