% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0setS4_QuantileGH.R
\docType{class}
\name{fmx-class}
\alias{fmx-class}
\title{Specification of \linkS4class{fmx} Class}
\description{
Parameter specification for a one-dimensional finite mixture distribution.
}
\section{Slots}{

\describe{
\item{\code{distname}}{\link[base]{character} scalar, 
name of parametric distribution of the mixture components.
Currently, normal (\code{'norm'}) and Tukey's \eqn{g}-&-\eqn{h} (\code{'GH'}) distributions are supported.}

\item{\code{parM}}{\link[base]{double} \link[base]{matrix}, 
all distribution parameters in the mixture. 
Each row corresponds to one component. Each column includes the same parameters of all components.
The order of rows corresponds to the (non-strictly) increasing order of the component location parameters.
The column names match the formal arguments of the corresponding distribution, 
e.g., \code{mean} and \code{sd} for norm distribution (see \code{\link[stats]{dnorm}}), 
or \code{A}, \code{B}, \code{g} and \code{h} for Tukey's \eqn{g}-&-\eqn{h} distribution (see \code{\link{dGH}}).}

\item{\code{w}}{\link[base]{numeric} vector of mixing proportions that must sum to 1}
}}

