% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmx_init.R
\name{fmx_hybrid}
\alias{fmx_hybrid}
\title{Best Naive Estimates for Finite Mixture Distribution}
\usage{
fmx_hybrid(x, test = c("logLik", "CvM", "KS"), ...)
}
\arguments{
\item{x}{\link[base]{numeric} \link[base]{vector}, observations}

\item{test}{\link[base]{character} scalar, criteria for selecting the optimal estimates.
See \strong{Details}.}

\item{...}{additional parameters of functions \link{fmx_normix} and \link{fmx_cluster}}
}
\value{
Function \link{fmx_hybrid} returns an \linkS4class{fmx} object.
}
\description{
Best estimates for finite mixture distribution \linkS4class{fmx}.
}
\details{
Function \link{fmx_hybrid} compares
Tukey \eqn{g}-&-\eqn{h} mixture estimate provided by function \link{fmx_cluster}
and the normal mixture estimate by function \link{fmx_normix},
and select the one either with maximum likelihood (\code{test = 'logLik'}, default),
with minimum Cramer-von Mises distance (\code{test = 'CvM'}) or
with minimum Kolmogorov distance (\link{Kolmogorov_fmx}).
}
\examples{
library(fmx)
d1 = fmx('norm', mean = c(1, 2), sd = .5, w = c(.4, .6))
set.seed(100); hist(x1 <- rfmx(n = 1e3L, dist = d1))
fmx_normix(x1, distname = 'norm', K = 2L)
fmx_normix(x1, distname = 'GH', K = 2L)

(d2 = fmx('GH', A = c(1,6), B = 2, g = c(0,.3), h = c(.2,0), w = c(1,2)))
set.seed(100); hist(x2 <- rfmx(n = 1e3L, dist = d2))
fmx_cluster(x2, K = 2L)
fmx_cluster(x2, K = 2L, constraint = c('g1', 'h2'))
fmx_normix(x2, K = 2L, distname = 'GH')
fmx_hybrid(x2, distname = 'GH', K = 2L)

}
