% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QuantumClone.R
\name{From_freq_to_cell}
\alias{From_freq_to_cell}
\title{Wrap-up function}
\usage{
From_freq_to_cell(SNV_list, FREEC_list = NULL, Sample_names,
  Genotype_provided = F, save_plot = T, contamination, ncores = 4,
  restrict.to.AB = F, output_directory = NULL)
}
\arguments{
\item{SNV_list}{A list of dataframes (one for each sample), with as columns : (for the first column of the first sample the name of the sample),
the chromosome "Chr",the position of the mutation "Start", the number of reads supporting the mutation "Alt", the depth of coverage at this locus "Depth",
and if the output from FREEC for the samples are not associated, the genotype "Genotype".}

\item{FREEC_list}{list of dataframes from FREEC for each samples (usually named Sample_ratio.txt), in the same order as SNV_list}

\item{Sample_names}{Name of the samples}

\item{Genotype_provided}{If the FREEC_list is provided, then should be FALSE (default), otherwise TRUE}

\item{save_plot}{Should the plots be saved? Default is TRUE}

\item{contamination}{Numeric vector giving the contamination by normal cells}

\item{ncores}{Number of cores to be used during EM algorithm}

\item{restrict.to.AB}{Should the analysis keep only sites located in A and AB sites in all samples?}

\item{output_directory}{Directory in which to save results}
}
\description{
Function that computes the most likely position for each mutation based on the genotype
}
\keyword{Clonal}
\keyword{inference}

