% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QuantumClone_v3.R
\name{ThreeD_plot}
\alias{ThreeD_plot}
\title{3D Plot}
\usage{
ThreeD_plot(Schrod, contamination)
}
\arguments{
\item{Schrod}{List of 2 dataframes, output of the Schrodinger function or the EM algorithm}

\item{contamination}{Numeric vector giving the proportion of normal cells in each samples}
}
\description{
Creates density plot when two samples are given
}
\examples{
print("Generating data...")
QC<-QuantumCat(number_of_clones = 4,number_of_mutations = 200,
               depth= 100, ploidy = "AB")
print("Formating data so it can be used as input")
alpha<-rep(1,time=200)
for(i in 1:2){
print(head(2*QC[[i]]$Alt/QC[[i]]$Depth))
QC[[i]][,4]<-2*QC[[i]]$Alt/QC[[i]]$Depth
QC[[i]]<-cbind(QC[[i]],alpha)
}
 print("Creating 3D plot")
ThreeD_plot(QC,c(0,0))
}
\keyword{Clonal}
\keyword{inference}
\keyword{phylogeny}

