% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantumClone.R
\name{Cluster_plot_from_cell}
\alias{Cluster_plot_from_cell}
\title{Cellularity clustering}
\usage{
Cluster_plot_from_cell(Cell, Sample_names, simulated, save_plot = TRUE,
  contamination, clone_priors, prior_weight, nclone_range, Initializations,
  preclustering = TRUE, epsilon = 5 * (10^(-3)), ncores = 2,
  output_directory = NULL, model.selection = "BIC", optim = "default",
  keep.all.models = FALSE)
}
\arguments{
\item{Cell}{Output from Return_one_cell_by_mut, list of cellularities (one list-element per sample)}

\item{Sample_names}{Name of the sample}

\item{simulated}{Was the data generated by QuantumCat?}

\item{save_plot}{Should the clustering plots be saved? Default is True}

\item{contamination}{The fraction of normal cells in the samples}

\item{clone_priors}{If known a list of priors (cell prevalence) to be used in the clustering}

\item{prior_weight}{If known a list of priors (fraction of mutations in a clone) to be used in the clustering}

\item{nclone_range}{Number of clusters to look for}

\item{Initializations}{Maximal number of independant initial condition tests to be tried}

\item{preclustering}{The type of preclustering used for priors: "Flash","kmedoid" or NULL. NULL will generate
centers using uniform distribution.}

\item{epsilon}{Stop value: maximal admitted value of the difference in cluster position and weights between two optimization steps.}

\item{ncores}{Number of CPUs to be used}

\item{output_directory}{Directory in which to save results}

\item{model.selection}{The function to minimize for the model selection: can be "AIC", "BIC", or numeric. In numeric, the function
uses a variant of the BIC by multiplication of the k*ln(n) factor. If >1, it will select models with lower complexity.}

\item{optim}{use L-BFS-G optimization from R ("default"), or from optimx ("optimx"), or Differential Evolution ("DEoptim")}

\item{keep.all.models}{Should the function output the best model (default; FALSE), or all models tested (if set to true)}
}
\description{
Clustering cellularities based on  the most likely presence of a clone, using the pamk algorithm (fpc package). Clustering can be guided by toggling manual_clustering on and/or giving a range of number of clusters.
}
\keyword{Clonal}
\keyword{inference}

