% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PartitionDistance.R
\name{CompareSplits}
\alias{CompareSplits}
\alias{CompareBipartitions}
\title{Compare status of splits}
\usage{
CompareSplits(splits, splits2)

CompareBipartitions(splits, splits2)
}
\arguments{
\item{splits}{An object that can be coerced into class \code{Splits} using
\code{\link[TreeTools]{as.Splits}}.}

\item{splits2}{Splits against which to compare \code{splits}.}
}
\value{
A named vector of eight integers, listing the number of unique splits
that:
\itemize{
\item \strong{N}    exist in total; i.e. the number of splits in \code{splits1} plus the
number in \code{splits2},
equivalent to 2 \emph{s} + \emph{d1} + \emph{d2} + \emph{r1} + \emph{r2};
\item \strong{P1}   occur in \code{splits1}
\item \strong{P2}   occur in \code{splits2}
\item \strong{s}    occur in both \code{splits1} and \code{splits2};
\item \strong{d1}   occur in \code{splits1} but are contradicted by \code{splits2};
\item \strong{d2}   occur in \code{splits2} but are contradicted by \code{splits1};
\item \strong{r1}   occur in \code{splits1} only, being neither present in nor contradicted by \code{splits2};
\item \strong{r2}   occur in \code{splits2} only, being neither present in nor contradicted by \code{splits1};
\item \strong{RF}   occur in one tree only; i.e. \emph{d1} + \emph{d2} + \emph{r1} + \emph{r2},
the Robinson-Foulds distance.
}
}
\description{
Reports whether splits are present or contradicted in a set of reference
splits.
}
\examples{
splits1 <- TreeTools::BalancedTree(8)
splits2 <- TreeTools::PectinateTree(8)

CompareSplits(splits1, splits2)
        
}
\references{
\itemize{
\item \insertRef{Estabrook1985}{Quartet}
\item \insertRef{Robinson1981}{Quartet}
}
}
\seealso{
Equivalent function for quartets: \code{\link[=CompareQuartets]{CompareQuartets()}}

Other element-by-element comparisons: 
\code{\link{CompareQuartetsMulti}()},
\code{\link{CompareQuartets}()},
\code{\link{PairSharedQuartetStatus}()},
\code{\link{QuartetState}()},
\code{\link{SharedQuartetStatus}()},
\code{\link{SplitStatus}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{element-by-element comparisons}
