% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlsolve.R
\docType{data}
\name{nlSolvers}
\alias{nlSolvers}
\alias{nlSolve}
\alias{nlsolve}
\title{Nonlinear equation solvers}
\format{\code{nlSolvers} is currently a named list of length 8.}
\usage{
nlSolvers

nlsolve(start, func, solvers = nlSolvers, control, ...)
}
\arguments{
\item{start}{A numeric vector of starting values.}

\item{func}{An objective function of which the zeros are sought.}

\item{solvers}{A (named) list, with each element being itself 
a list with components named \code{solve}, \code{success} and 
\code{result}. See the \code{solvers} argument of \code{\link{glmsolve}}.}

\item{control}{See the \code{control} argument of \code{\link{glmsolve}}.}

\item{...}{Additional arguments.}
}
\value{
If at least one solver succeeds, a numeric vector of solutions
will be returned, with attribute \code{attr(*, 'nlsolve.metho')} 
set to a string indicating the name of the success solver being used, 
and with attribute \code{attr(*, 'nlsolve.success')} being a logical
scalar indicating whether any solver succeeded. When all solvers 
fail, the last one is returned, but with \code{nlsolve.success} being 
set to \code{FALSE}.
}
\description{
\code{nlsolve} sequentially tries multiple nonliear equation solvers 
until a solution is found or all solvers have been tried.
}
\details{
Currently supported solvers are \code{c('broyden', 'nleqslv.Broyden',
'nleqslv.Newton','fsolve','newtonsys','sane','dfsane','BBsolve')}. 
They are respectively \code{\link[pracma]{broyden}} in the \code{pracma}
package, \code{\link[nleqslv]{nleqslv}} in the \code{nleqslv} with 
\code{method='Broyden'} or with \code{method='Newton'}, functions
\code{\link[pracma]{fsolve}} and \code{\link[pracma]{newtonsys}} 
in the \code{pracma} package, and functions \code{\link[BB]{sane}}, 
\code{\link[BB]{dfsane}}, and \code{\link[BB]{BBsolve}} in the 
\code{BB} package.
}
\examples{
str(nlSolvers) ## list of existing solvers
}
\seealso{
\code{\link[pracma]{broyden}}, \code{\link[nleqslv]{nleqslv}},
\code{\link[pracma]{fsolve}},  \code{\link[pracma]{newtonsys}},
\code{\link[BB]{sane}}, \code{\link[BB]{dfsane}}, \code{\link[BB]{BBsolve}},
\code{\link{glmsolve}}.
}
\author{
Long Qu
}
\keyword{datasets}
\keyword{iteration}
