% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_plots.R
\name{plot.gcFitModel}
\alias{plot.gcFitModel}
\title{Generic plot function for \code{gcFitModel} objects.}
\usage{
\method{plot}{gcFitModel}(
  x,
  raw = TRUE,
  pch = 1,
  colData = 1,
  equation = TRUE,
  eq.size = 1,
  colModel = "forestgreen",
  basesize = 16,
  cex.point = 2,
  lwd = 0.7,
  x.lim = NULL,
  y.lim = NULL,
  n.ybreaks = 6,
  plot = TRUE,
  export = FALSE,
  height = 6,
  width = 8,
  out.dir = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{gcFittedModel} object created with \code{\link{growth.gcFitModel}} or stored within a \code{grofit} or \code{gcFit} object created with \code{\link{growth.workflow}} or \code{\link{growth.gcFit}}, respectively.}

\item{raw}{(Logical) Show the raw data within the plot (\code{TRUE}) or not (\code{FALSE}).}

\item{pch}{(Numeric) Symbol used to plot data points.}

\item{colData}{(Numeric or Character) Color used to plot the raw data.}

\item{equation}{(Logical) Show the equation of the fitted model within the plot (\code{TRUE}) or not (\code{FALSE}).}

\item{eq.size}{(Numeric) Provide a value to scale the size of the displayed equation.}

\item{colModel}{(Numeric or Character) Color used to plot the fitted model.}

\item{basesize}{(Numeric) Base font size.}

\item{cex.point}{(Numeric) Size of the raw data points.}

\item{lwd}{(Numeric) Spline line width.}

\item{x.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on the x-axis as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{y.lim}{(Numeric vector with two elements) Optional: Provide the lower (\code{l}) and upper (\code{u}) bounds on y-axis of the growth curve plot as a vector in the form \code{c(l, u)}. If only the lower or upper bound should be fixed, provide \code{c(l, NA)} or \code{c(NA, u)}, respectively.}

\item{n.ybreaks}{(Numeric) Number of breaks on the y-axis. The breaks are generated using \code{scales::pretty_breaks}. Thus, the final number of breaks can deviate from the user input.}

\item{plot}{(Logical) Show the generated plot in the \code{Plots} pane (\code{TRUE}) or not (\code{FALSE}). If \code{FALSE}, a ggplot object is returned.}

\item{export}{(Logical) Export the generated plot as PDF and PNG files (\code{TRUE}) or not (\code{FALSE}).}

\item{height}{(Numeric) Height of the exported image in inches.}

\item{width}{(Numeric) Width of the exported image in inches.}

\item{out.dir}{(Character) Name or path to a folder in which the exported files are stored. If \code{NULL}, a "Plots" folder is created in the current working directory to store the files in.}

\item{...}{Further arguments to refine the generated \code{ggplot2} plot.}
}
\value{
A plot with the parametric fit.
}
\description{
Plot the results of a parametric model fit on growth vs. time data
}
\examples{
# Create random growth dataset
rnd.dataset <- rdm.data(d = 35, mu = 0.8, A = 5, label = "Test1")

# Extract time and growth data for single sample
time <- rnd.dataset$time[1,]
data <- rnd.dataset$data[1,-(1:3)] # Remove identifier columns

# Perform parametric fit
TestFit <- growth.gcFitModel(time, data, gcID = "TestFit",
                 control = growth.control(fit.opt = "m"))

plot(TestFit, basesize = 18, eq.size = 1.5)

}
