% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric_fits.R
\name{flBootSpline}
\alias{flBootSpline}
\title{flBootSpline: Function to generate a bootstrap}
\usage{
flBootSpline(
  time = NULL,
  growth = NULL,
  fl_data,
  ID = "undefined",
  control = fl.control()
)
}
\arguments{
\item{time}{Vector of the independent variable: time (if \code{x_type = 'time'} in \code{fl.control} object.}

\item{growth}{Vector of the independent variable: growth (if \code{x_type = 'growth'} in \code{fl.control} object.}

\item{fl_data}{Vector of dependent variable: fluorescence.}

\item{ID}{(Character) The name of the analyzed sample.}

\item{control}{A \code{fl.control} object created with \code{\link{fl.control}}, defining relevant fitting options.}
}
\value{
A \code{gcBootSpline} object containing a distribution of fluorescence parameters and
a \code{flFitSpline} object for each bootstrap sample. Use \code{\link{plot.gcBootSpline}}
to visualize all bootstrapping splines as well as the distribution of
physiological parameters.
\item{raw.x}{Raw time values provided to the function as \code{time}.}
\item{raw.fl}{Raw growth data provided to the function as \code{data}.}
\item{ID}{(Character) Identifies the tested sample.}
\item{boot.x}{Table of time values per column, resulting from each spline fit of the bootstrap.}
\item{boot.fl}{Table of growth values per column, resulting from each spline fit of the bootstrap.}
\item{boot.flSpline}{List of \code{flFitSpline} object, created by \code{\link{flFitSpline}} for each resample of the bootstrap.}
\item{lambda}{Vector of estimated lambda (lag time) values from each bootstrap entry.}
\item{max_slope}{Vector of estimated max_slope (maximum slope) values from each bootstrap entry.}
\item{A}{Vector of estimated A (maximum fluorescence) values from each bootstrap entry.}
\item{integral}{Vector of estimated integral values from each bootstrap entry.}
\item{bootFlag}{(Logical) Indicates the success of the bootstrapping operation.}
\item{control}{Object of class \code{fl.control} containing list of options passed to the function as \code{control}.}
}
\description{
\code{fl.gcBootSpline} resamples the fluorescence-'x' value pairs in a dataset with replacement and performs a spline fit for each bootstrap sample.
}
\examples{
# load example dataset
input <- read_data(data.growth = system.file("lac_promoters_growth.txt", package = "QurvE"),
                   data.fl = system.file("lac_promoters_fluorescence.txt", package = "QurvE"),
                   csvsep = "\t",
                   csvsep.fl = "\t")

# Extract time and normalized fluorescence data for single sample
time <- input$time[4,]
data <- input$norm.fluorescence[4,-(1:3)] # Remove identifier columns

# Perform linear fit
TestFit <- flBootSpline(time = time,
                       fl_data = data,
                       ID = 'TestFit',
                       control = fl.control(fit.opt = 's', x_type = 'time',
                       nboot.fl = 50))

plot(TestFit, combine = TRUE, lwd = 0.5)
}
\seealso{
Other fluorescence fitting functions: 
\code{\link{flFitSpline}()},
\code{\link{flFit}()}
}
\concept{fluorescence fitting functions}
