% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rmatrix.R
\name{get.Rmatrix}
\alias{get.Rmatrix}
\title{Restriction matrix}
\usage{
get.Rmatrix(Q.i, Q.i.k)
}
\arguments{
\item{Q.i}{A q-vector}

\item{Q.i.k}{Another q-vector}
}
\value{
A restriction matrix
}
\description{
This function returns the restriction matrix (de la Torre, 2011; Ma & de la Torre, 2020) based on two q-vectors, 
where the two q-vectors can only differ by one attribute.
}
\examples{
Q.i <- c(1, 1, 0)
Q.i.k <- c(1, 1, 1)

Rmatrix <- get.Rmatrix(Q.i, Q.i.k)

print(Rmatrix)


}
\references{
de la Torre, J. (2011). The Generalized DINA Model Framework. Psychometrika, 76(2), 179-199. DOI: 10.1007/s11336-011-9207-7.

Ma, W., & de la Torre, J. (2020). An empirical Q-matrix validation method for the sequential generalized DINA model. British Journal of Mathematical and Statistical Psychology, 73(1), 142-163. DOI: 10.1111/bmsp.12156.
}
