% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3Summary.R
\name{summary}
\alias{summary}
\alias{summary.CDM}
\alias{summary.validation}
\alias{summary.sim.data}
\title{Summary Methods for Various Objects}
\usage{
\method{summary}{CDM}(object, ...)

\method{summary}{validation}(object, ...)

\method{summary}{sim.data}(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link[Qval]{CDM}}, \code{\link[Qval]{validation}}, or \code{\link[Qval]{sim.data}}.}

\item{...}{Currently unused. Additional arguments are ignored.}
}
\value{
A named list with class \code{summary.<class>} containing the components above.
}
\description{
Generate concise summary statistics for objects created by the Qval package.
The output is a named list tailored to the class of the input:
\describe{
  \item{\code{\link[Qval]{CDM}}}{contains the original call, dataset dimensions, model fit object, and attribute-pattern distribution.}
  \item{\code{\link[Qval]{validation}}}{contains the original call, suggested Q-matrix, and original Q-matrix.}
  \item{\code{\link[Qval]{sim.data}}}{contains the original call, dataset dimensions, and attribute-pattern distribution.}
}
}
\details{
\describe{
  \item{call}{A string capturing the original function invocation.}
  \item{base}{A numeric vector \code{c(N, I, K)} giving the number of examinees (\eqn{N}), 
              the number of items (\eqn{I}), and the number of attributes (\eqn{K}).}
  \item{model.fit}{(CDM only) The fitted model object returned by \code{\link[Qval]{CDM}}.}
  \item{patterns}{(CDM and sim.data) A data.frame of frequencies (\code{freq}) and proportions 
                  (\code{prop}) of each attribute pattern.}
  \item{Q.sug}{(validation only) Suggested Q-matrix from \code{\link[Qval]{validation}}.}
  \item{Q.orig}{(validation only) Original Q-matrix provided to \code{\link[Qval]{sim.data}}.}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{summary(CDM)}: Summary method for CDM objects

\item \code{summary(validation)}: Summary method for validation objects

\item \code{summary(sim.data)}: Summary method for sim.data objects

}}
\examples{
set.seed(123)
library(Qval)

\donttest{
################################################################
# Example 1: summary a CDM object                              #
################################################################
Q <- sim.Q(3, 20)
IQ <- list(P0 = runif(20, 0, 0.2), P1 = runif(20, 0.8, 1))
data.obj <- sim.data(Q, N = 500, IQ = IQ, 
                     model = "GDINA", distribute = "horder")
CDM.obj <- CDM(data.obj$dat, Q, model = "GDINA", method = "EM")
summary(CDM.obj)


################################################################
# Example 2: summary a validation object                       #
################################################################
MQ <- sim.MQ(Q, 0.1)
CDM.obj2 <- CDM(data.obj$dat, MQ)
val.obj <- validation(data.obj$dat, MQ, CDM.obj2, method = "GDI")
summary(val.obj)


################################################################
# Example 3: summary a sim.data object                         #
################################################################
data.obj2 <- sim.data(Q = sim.Q(3, 10), N = 1000)
summary(data.obj2)
}

}
