% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{set_corpus_variables}
\alias{set_corpus_variables}
\title{set_corpus_variables}
\usage{
set_corpus_variables(corpus, dset)
}
\arguments{
\item{corpus}{A \code{Corpus} object.}

\item{dset}{A \code{data.frame} containing meta-data variables, with one row per document in `corpus.}
}
\value{
A \code{Corpus} object with meta-data added.
}
\description{
Set corpus meta-data variables from a data frame.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
dset <- data.frame(x=1:length(corpus))
corpus <- set_corpus_variables(corpus, dset)

}
