% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MCSE.R
\name{MCSE}
\alias{MCSE}
\title{Calculates the estimated Monte Carlo standard error (MCSE)}
\usage{
MCSE(chain, rho, ll = 0.5, ul = 20)
}
\arguments{
\item{chain}{Vector or \code{\link[coda]{mcmc}} object.}

\item{rho}{ACF for first lag.}

\item{ll}{Lower limit of x-axis, where value specified is multiplied by the length of the chain. Defaults to \code{0.5}.}

\item{ul}{Upper limit of x-axis, where value specified is multiplied by the length of the chain. Defaults to \code{20}.}
}
\value{
The Monte Carlo standard error (MCSE) for the posterior estimate of the mean is returned.
}
\description{
An internal function which calculates the estimated Monte Carlo standard
error (MCSE) for the posterior estimate of the mean, for use in \code{\link{sixway}}.
As MCMC is a simulation-based approach this induces (Monte Carlo) uncertainty
due to the random numbers it uses. This uncertainty reduces with more
iterations, and is measured by the MCSE. See Browne (2012) for further details.
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2015) Centre for Multilevel Modelling, University of Bristol.
}
\references{
Browne, W.J. (2012) MCMC Estimation in MLwiN, v2.26.
Centre for Multilevel Modelling, University of Bristol.
}
\seealso{
\code{\link{sixway}}
}

