\name{bugs.script}
\alias{bugs.script}

\title{Writes script for running WinBUGS}

\description{Write file \file{script.txt} for \pkg{WinBUGS} to read -
  intended for internal use}

\usage{
bugs.script(parameters.to.save, n.chains, n.iter, n.burnin, n.thin,
    model.file, debug=FALSE, is.inits, bin, DIC=FALSE,
    useWINE=.Platform$OS.type != "windows", newWINE=TRUE, WINEPATH=NULL)
}
\arguments{
  \item{parameters.to.save}{parameters that should be monitored}
  \item{n.chains}{number of Markov chains}
  \item{n.iter}{number of total iterations (including burn in)}
  \item{n.burnin}{length of burn in}
  \item{n.thin}{size of thinning parameter}
  \item{model.file}{file containing the model written in \pkg{WinBUGS} code}
  \item{debug}{if \code{FALSE}, \pkg{WinBUGS} is closed automatically,
    otherwise \pkg{WinBUGS} remains open for further investigation}
  \item{is.inits}{logical; whether initial values are given by the user
    (\code{TRUE}) or have to be generated by \pkg{WinBUGS}}
  \item{bin}{number of iterations between saving of results}
  \item{DIC}{logical; if \code{TRUE}, compute deviance, pD, and DIC
    automatically in \pkg{WinBUGS}}
  \item{useWINE}{as in \code{\link{bugs}} meta function}
  \item{newWINE}{as in \code{\link{bugs}} meta function}
  \item{WINEPATH}{as in \code{\link{bugs}} meta function}
}

\value{Nothing, but as a side effect, the script file \file{script.txt}
  is written}

\seealso{The main function to be called by the user is \code{\link{bugs}}.}
\keyword{internal}
\keyword{file}
\keyword{IO}
